import { Result } from "@gnuxie/typescript-result";
import { StringEventID, StringRoomAlias, StringRoomID, StringUserID } from "../StringlyTypedMatrix";
export declare const MatrixToRegex: RegExp;
/**
 * The parts of a permalink.
 * @see Permalinks
 * @category Utilities
 */
export interface PermalinkParts {
    /**
     * The roomID that the Permalink references.
     */
    roomID?: StringRoomID;
    /**
     * The roomAlias that the Permalink references.
     */
    roomAlias?: StringRoomAlias;
    /**
     * The user ID the permalink references. May be undefined.
     */
    userID?: StringUserID;
    /**
     * The event ID the permalink references. May be undefined.
     */
    eventID?: StringEventID;
    /**
     * The servers the permalink is routed through.
     */
    viaServers: string[];
}
/**
 * Functions for handling permalinks
 * @category Utilities
 */
export declare class Permalinks {
    private constructor();
    private static encodeViaArgs;
    /**
     * Creates a room permalink.
     * @param {string} roomIDOrAlias The room ID or alias to create a permalink for.
     * @param {string[]} viaServers The servers to route the permalink through.
     * @returns {string} A room permalink.
     */
    static forRoom(roomIDOrAlias: StringRoomID | StringRoomAlias, viaServers?: string[]): string;
    /**
     * Creates a user permalink.
     * @param {string} userID The user ID to create a permalink for.
     * @returns {string} A user permalink.
     */
    static forUser(userID: StringUserID): string;
    /**
     * Creates an event permalink.
     * @param {string} roomIDOrAlias The room ID or alias to create a permalink in.
     * @param {string} eventID The event ID to reference in the permalink.
     * @param {string[]} viaServers The servers to route the permalink through.
     * @returns {string} An event permalink.
     */
    static forEvent(roomIDOrAlias: StringRoomID | StringRoomAlias, eventID: StringEventID, viaServers?: string[]): string;
    /**
     * Parses a permalink URL into usable parts.
     * @param {string} matrixTo The matrix.to URL to parse.
     * @returns {PermalinkParts} The parts of the permalink.
     */
    static parseUrl(matrixTo: string): Result<PermalinkParts>;
}
//# sourceMappingURL=Permalinks.d.ts.map