"use strict";
// Copyright 2022-2025 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from Draupnir
// https://github.com/the-draupnir-project/Draupnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderElaborationTrail = renderElaborationTrail;
exports.renderDetailsNotice = renderDetailsNotice;
exports.renderExceptionTrail = renderExceptionTrail;
exports.renderFailedSingularConsequence = renderFailedSingularConsequence;
exports.renderOutcome = renderOutcome;
exports.renderRoomOutcome = renderRoomOutcome;
exports.renderUserOutcome = renderUserOutcome;
exports.renderRoomSetResult = renderRoomSetResult;
exports.renderResultForUsersInRoom = renderResultForUsersInRoom;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const MatrixHelpRenderer_1 = require("./MatrixHelpRenderer");
function renderElaborationTrail(error) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null, "Elaboration trail"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, error.getElaborations().map((elaboration) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("pre", null, elaboration)))))));
}
function renderDetailsNotice(error) {
    if (!(error instanceof matrix_protection_suite_1.ActionException)) {
        return interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null);
    }
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("p", null,
        "Details can be found by providing the reference ",
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, error.uuid),
        "to an administrator."));
}
function renderExceptionTrail(error) {
    if (!(error instanceof matrix_protection_suite_1.ActionException)) {
        return interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null);
    }
    if (!(error.exception instanceof Error)) {
        return interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null);
    }
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
            "Stack Trace for: ",
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, error.exception.name)),
        interface_manager_1.DeadDocumentJSX.JSXFactory("pre", null, error.exception.toString())));
}
function renderFailedSingularConsequence(description, title, error) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null,
                interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, description.name),
                ": ",
                title,
                " - ",
                renderOutcome(false)),
            error.mostRelevantElaboration,
            renderDetailsNotice(error),
            renderElaborationTrail(error),
            renderExceptionTrail(error))));
}
function renderOutcome(isOutcomeOk) {
    const colour = isOutcomeOk ? "#7cfc00" : "#E01F2B";
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("span", { "data-mx-color": colour }, isOutcomeOk ? "OK" : "Failed")));
}
function renderRoomOutcomeOk(roomID) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("span", null,
        (0, MatrixHelpRenderer_1.renderRoomPill)(matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID)),
        " -",
        " ",
        renderOutcome(true)));
}
function renderUserOutcomeOk(userID, _result) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("span", null,
        (0, MatrixHelpRenderer_1.renderMentionPill)(userID, userID),
        " - ",
        renderOutcome(true)));
}
function renderOutcomeError(summary, error) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null, summary),
            renderDetailsNotice(error),
            renderElaborationTrail(error),
            renderExceptionTrail(error))));
}
function renderRoomOutcomeError(roomID, error) {
    return renderOutcomeError(interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        (0, MatrixHelpRenderer_1.renderRoomPill)(matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID)),
        " -",
        " ",
        renderOutcome(false),
        ": ",
        error.mostRelevantElaboration), error);
}
function renderUserOutcomeError(userID, error) {
    return renderOutcomeError(interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        (0, MatrixHelpRenderer_1.renderMentionPill)(userID, userID),
        " - ",
        renderOutcome(false)), error);
}
function renderRoomOutcome(roomID, result) {
    if ((0, matrix_protection_suite_1.isOk)(result)) {
        return renderRoomOutcomeOk(roomID);
    }
    else {
        return renderRoomOutcomeError(roomID, result.error);
    }
}
function renderUserOutcome(userID, result) {
    if ((0, matrix_protection_suite_1.isOk)(result)) {
        return renderUserOutcomeOk(userID, result);
    }
    else {
        return renderUserOutcomeError(userID, result.error);
    }
}
function renderRoomSetResult(roomResults, { summary }) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null, summary),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, [...roomResults.map.entries()].map(([roomID, outcome]) => {
            return interface_manager_1.DeadDocumentJSX.JSXFactory("li", null, renderRoomOutcome(roomID, outcome));
        }))));
}
function renderResultForUsersInRoom(results, { summary }) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("details", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("summary", null, summary),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, [...results.map.entries()].map(([userID, outcome]) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null, renderUserOutcome(userID, outcome)))))));
}
//# sourceMappingURL=CommonRenderers.js.map