import { Result } from "@gnuxie/typescript-result";
import { MatrixAdaptorContext, MatrixEventContext } from "./MPSMatrixInterfaceAdaptor";
import { DocumentNode, MatrixInterfaceCommandDispatcher } from "@the-draupnir-project/interface-manager";
import { RoomEvent } from "matrix-protection-suite";
import { MatrixReactionHandler, ReactionListener } from "./MatrixReactionHandler";
import { StringRoomID } from "@the-draupnir-project/matrix-basic-types";
export declare const COMMAND_CONFIRMATION_LISTENER = "me.marewolf.draupnir.command_confirmation";
export declare function makeConfirmationPromptListener(commandRoomID: StringRoomID, commandDispatcher: MatrixInterfaceCommandDispatcher<MatrixEventContext>, reactionHandler: MatrixReactionHandler): ReactionListener;
export type ConfirmationPromptSender = ({ commandDesignator, readItems, }: {
    commandDesignator: string[];
    readItems: string[];
}, document: DocumentNode, { roomID, event, }: {
    roomID?: StringRoomID | undefined;
    event?: RoomEvent | undefined;
}) => Promise<Result<void>>;
export declare function makeconfirmationPromptSender(adaptorContext: MatrixAdaptorContext): ConfirmationPromptSender;
/**
 * This utility allows protections to send confirmation prompts that appear like confirmation prompts
 * for commands that have been sent without the `--no-confirm` option, but require confirmation.
 */
export declare function sendConfirmationPrompt({ clientPlatform, reactionHandler }: MatrixAdaptorContext, { commandDesignator, readItems, }: {
    commandDesignator: string[];
    readItems: string[];
}, document: DocumentNode, { roomID, event, }: {
    roomID?: StringRoomID | undefined;
    event?: RoomEvent | undefined;
}): Promise<Result<void>>;
export declare const matrixEventsFromConfirmationPrompt: (adaptorContext: MatrixAdaptorContext, { event }: MatrixEventContext, command: import("@the-draupnir-project/interface-manager").CompleteCommand, document: DocumentNode) => Promise<Result<void>>;
//# sourceMappingURL=MatrixPromptForConfirmation.d.ts.map