"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.BotSDKAllClient = void 0;
const BotSDKBaseClient_1 = require("./BotSDKBaseClient");
/**
 * This is a client that implements all granular capabilities specified in the
 * matrix-protection-suite. We depeond on the type system to enforce the attenuation
 * of capabilities, which is completely wrong. We should have the abilitiy to create
 * purpose built capabilities by using mixins, but this would require desgining
 * a purpose built object system on top of JS and this is something that would
 * take time and consideration to do properly.
 */
class BotSDKAllClient extends BotSDKBaseClient_1.BotSDKBaseClient {
    constructor(client, clientRooms, decoder) {
        super(client, clientRooms.clientUserID, clientRooms, decoder);
    }
    preemptTimelineJoin(roomID) {
        this.clientRooms.preemptTimelineJoin(roomID);
    }
}
exports.BotSDKAllClient = BotSDKAllClient;
//# sourceMappingURL=BotSDKAllClient.js.map