import { ActionException, ActionResult, RoomBanner, RoomCreateOptions, RoomCreator, RoomEventRedacter, RoomJoiner, RoomKicker, RoomStateEventSender, RoomEvent, EventDecoder, RoomMessageSender, MessageContent, ClientRooms, RoomStateGetter, StateEvent, ClientCapabilitiesNegotiation, ClientCapabilitiesResponse, RoomMessages, PaginationIterator, RoomMessagesOptions, RoomMessagesPaginator, RoomEventRelations, RoomEventRelationsPaginator, RoomEventRelationsOptions } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { MatrixRoomID, StringRoomID, StringUserID, MatrixRoomReference, StringRoomAlias, StringEventID } from '@the-draupnir-project/matrix-basic-types';
import { RoomReactionSender } from 'matrix-protection-suite/dist/Client/RoomReactionSender';
import { RoomEventGetter } from 'matrix-protection-suite/dist/Client/RoomEventGetter';
export declare function is404(error: unknown): boolean;
export declare function resultifyBotSDKRequestErrorWith404AsUndefined(error: unknown): ActionResult<undefined, ActionException>;
export declare function resultifyBotSDKRequestError(error: unknown): ActionResult<never, ActionException>;
export declare class BotSDKBaseClient implements ClientCapabilitiesNegotiation, RoomBanner, RoomCreator, RoomEventGetter, RoomEventRedacter, RoomEventRelations, RoomJoiner, RoomKicker, RoomMessages, RoomMessageSender, RoomReactionSender, RoomStateEventSender, RoomStateGetter {
    protected readonly client: MatrixSendClient;
    protected readonly clientUserID: StringUserID;
    protected readonly clientRooms: ClientRooms;
    protected readonly eventDecoder: EventDecoder;
    constructor(client: MatrixSendClient, clientUserID: StringUserID, clientRooms: ClientRooms, eventDecoder: EventDecoder);
    protected preemptTimelineJoin(_roomID: StringRoomID): void;
    getClientCapabilities(): Promise<ActionResult<ClientCapabilitiesResponse>>;
    sendMessage<TContent extends MessageContent>(roomID: StringRoomID, content: TContent): Promise<ActionResult<StringEventID>>;
    getEvent<TRoomEvent extends RoomEvent>(roomID: StringRoomID, eventID: StringEventID): Promise<ActionResult<TRoomEvent>>;
    getUndecodedEvent(roomID: StringRoomID, eventID: StringEventID): Promise<ActionResult<Record<string, unknown>>>;
    sendReaction(roomID: StringRoomID, eventID: StringEventID, key: string): Promise<ActionResult<StringEventID>>;
    resolveRoom(room: MatrixRoomReference | StringRoomAlias | StringRoomID): Promise<ActionResult<MatrixRoomID>>;
    inviteUser(room: MatrixRoomID | StringRoomID, userID: StringUserID, reason?: string): Promise<ActionResult<void>>;
    joinRoom(room: MatrixRoomReference | StringRoomID | StringRoomAlias, rawOptions?: {
        alwaysCallJoin?: boolean;
    }): Promise<ActionResult<MatrixRoomID>>;
    createRoom(options: RoomCreateOptions): Promise<ActionResult<MatrixRoomID>>;
    banUser(room: StringRoomID | MatrixRoomID, userID: StringUserID, reason?: string): Promise<ActionResult<void>>;
    kickUser(room: StringRoomID | MatrixRoomID, userID: StringUserID, reason?: string): Promise<ActionResult<void>>;
    redactEvent(room: StringRoomID | MatrixRoomID, eventID: StringEventID, reason?: string): Promise<ActionResult<StringEventID>>;
    toRoomEventRelationsPaginator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, eventID: StringEventID): RoomEventRelationsPaginator<TEvent>;
    toRoomEventRelationsIterator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, eventID: StringEventID, options: RoomEventRelationsOptions): PaginationIterator<TEvent>;
    getAllState<T extends StateEvent>(room: MatrixRoomID | StringRoomID): Promise<ActionResult<T[]>>;
    unbanUser(room: StringRoomID | MatrixRoomID, userID: StringUserID): Promise<ActionResult<void>>;
    sendStateEvent(room: MatrixRoomID | StringRoomID, stateType: string, stateKey: string, content: Record<string, unknown>): Promise<ActionResult<StringEventID>>;
    toRoomMessagesPaginator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID): RoomMessagesPaginator<TEvent>;
    toRoomMessagesIterator<TEvent extends RoomEvent = RoomEvent>(roomID: StringRoomID, options: RoomMessagesOptions): PaginationIterator<TEvent>;
}
//# sourceMappingURL=BotSDKBaseClient.d.ts.map