"use strict";
/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.joinedRoomsSafe = joinedRoomsSafe;
const matrix_protection_suite_1 = require("matrix-protection-suite");
async function joinedRoomsSafe(client) {
    return await client.getJoinedRooms().then((rooms) => (0, matrix_protection_suite_1.Ok)(rooms), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to get joined rooms`, {
        exception,
        exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
    }));
}
//# sourceMappingURL=ClientManagement.js.map