/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 */
import { ActionResult, MatrixAccountData, MatrixStateData, PersistentConfigBackend, RoomStateRevisionIssuer, Value } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
export declare class BotSDKAccountDataConfigBackend<TEncodedShape extends Record<string, unknown> = Record<string, unknown>> implements PersistentConfigBackend<TEncodedShape> {
    private readonly client;
    private readonly eventType;
    constructor(client: MatrixSendClient, eventType: string);
    requestUnparsedConfig(): Promise<ActionResult<Record<string, unknown> | undefined>>;
    saveEncodedConfig(data: TEncodedShape): Promise<ActionResult<void>>;
    saveUnparsedConfig(data: Record<string, unknown>): Promise<ActionResult<void>>;
}
export declare class BotSDKMatrixAccountData<T> implements MatrixAccountData<T> {
    private readonly eventType;
    private readonly eventSchema;
    private readonly client;
    constructor(eventType: string, eventSchema: Parameters<(typeof Value)['Decode']>[0], client: MatrixSendClient);
    requestAccountData(): Promise<ActionResult<T | undefined>>;
    storeAccountData(data: T): Promise<ActionResult<void>>;
}
export declare class BotSDKRoomStateConfigBackend<TEncodedShape extends Record<string, unknown> = Record<string, unknown>> implements PersistentConfigBackend<TEncodedShape> {
    private readonly client;
    private readonly roomID;
    private readonly eventType;
    private readonly stateKey;
    constructor(client: MatrixSendClient, roomID: StringRoomID, eventType: string, stateKey: string);
    requestUnparsedConfig(): Promise<ActionResult<Record<string, unknown> | undefined>>;
    saveEncodedConfig(data: TEncodedShape): Promise<ActionResult<void>>;
}
export declare class BotSDKMatrixStateData<T> implements MatrixStateData<T> {
    private readonly eventType;
    private readonly roomStateRevisionIssuer;
    private readonly client;
    constructor(eventType: string, roomStateRevisionIssuer: RoomStateRevisionIssuer, client: MatrixSendClient);
    requestStateContent(state_key: string): T | undefined;
    storeStateContent(state_key: string, content: T): Promise<ActionResult<void>>;
}
//# sourceMappingURL=MatrixData.d.ts.map