"use strict";
/**
 * Copyright (C) 2024 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BotSDKLogServiceLogger = void 0;
const matrix_bot_sdk_1 = require("matrix-bot-sdk");
/**
 * A logger provider that uses the `LogService` from the bot-sdk to provide logging capability.
 * @see {@link setGlobalLoggerProvider}
 */
class BotSDKLogServiceLogger {
    debug(moduleName, message, ...parts) {
        matrix_bot_sdk_1.LogService.debug(moduleName, message, ...parts);
    }
    info(moduleName, message, ...parts) {
        matrix_bot_sdk_1.LogService.info(moduleName, message, ...parts);
    }
    warn(moduleName, message, ...parts) {
        matrix_bot_sdk_1.LogService.warn(moduleName, message, ...parts);
    }
    error(moduleName, message, ...parts) {
        matrix_bot_sdk_1.LogService.error(moduleName, message, ...parts);
    }
}
exports.BotSDKLogServiceLogger = BotSDKLogServiceLogger;
//# sourceMappingURL=BotSDKLogging.js.map