/**
 * Copyright (C) 2022-2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 *
 * This file is modified and is NOT licensed under the Apache License.
 * This modified file incorperates work from mjolnir
 * https://github.com/matrix-org/mjolnir
 * which included the following license notice:

Copyright 2019-2021 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 *
 * However, this file is modified and the modifications in this file
 * are NOT distributed, contributed, committed, or licensed under the Apache License.
 */
import { ActionResult, PolicyRoomManager, RoomCreateOptions, PolicyRuleEvent, PolicyRoomEditor, PolicyRoomRevisionIssuer, PolicyRuleType, ClientsInRoomMap, ClientPlatform } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { RoomStateManagerFactory } from '../ClientManagement/RoomStateManagerFactory';
import { MatrixRoomID, StringUserID, MatrixRoomReference } from '@the-draupnir-project/matrix-basic-types';
export declare class BotSDKPolicyRoomManager implements PolicyRoomManager {
    readonly clientUserID: StringUserID;
    private readonly client;
    private readonly clientPlatform;
    private readonly factory;
    private readonly joinPreempter;
    private readonly issuedEditors;
    constructor(clientUserID: StringUserID, client: MatrixSendClient, clientPlatform: ClientPlatform, factory: RoomStateManagerFactory, joinPreempter: Pick<ClientsInRoomMap, 'preemptTimelineJoin'>);
    getPolicyRoomEditor(room: MatrixRoomID): Promise<ActionResult<PolicyRoomEditor>>;
    createPolicyRoom(shortcode: string, invite: string[], createRoomOptions: RoomCreateOptions): Promise<ActionResult<MatrixRoomID>>;
    getPolicyRuleEvents(room: MatrixRoomReference): Promise<ActionResult<PolicyRuleEvent[]>>;
    getPolicyRoomRevisionIssuer(room: MatrixRoomID): Promise<ActionResult<PolicyRoomRevisionIssuer>>;
    getEditablePolicyRoomIDs(editor: StringUserID, ruleType: PolicyRuleType): MatrixRoomID[];
}
//# sourceMappingURL=PolicyListManager.d.ts.map