"use strict";
/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BotSDKMjolnirProtectedRoomsStore = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
class BotSDKMjolnirProtectedRoomsStore {
    constructor(client) {
        this.client = client;
        // nothing to do.
    }
    requestPersistentData() {
        return this.client.getAccountData(matrix_protection_suite_1.MJOLNIR_PROTECTED_ROOMS_EVENT_TYPE).then((value) => matrix_protection_suite_1.Value.Decode(matrix_protection_suite_1.MjolnirProtectedRoomsEvent, value), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to load the account data for mjolnir protected_rooms`, { exception, exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown }));
    }
    async storePersistentData(data) {
        const encodedData = matrix_protection_suite_1.Value.Encode(matrix_protection_suite_1.MjolnirProtectedRoomsEvent, data);
        if ((0, matrix_protection_suite_1.isError)(encodedData)) {
            return encodedData;
        }
        return this.client
            .setAccountData(matrix_protection_suite_1.MJOLNIR_PROTECTED_ROOMS_EVENT_TYPE, encodedData.ok)
            .then((_value) => (0, matrix_protection_suite_1.Ok)(undefined), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to set account data for mjolnir protected_rooms event`, { exception, exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown }));
    }
}
exports.BotSDKMjolnirProtectedRoomsStore = BotSDKMjolnirProtectedRoomsStore;
//# sourceMappingURL=MjolnirProtectedRoomsStore.js.map