/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
import { ActionResult, RoomMembershipManager, RoomMembershipRevisionIssuer } from 'matrix-protection-suite';
import { MembershipEvent } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { RoomStateManagerFactory } from '../ClientManagement/RoomStateManagerFactory';
import { MatrixRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export declare class BotSDKRoomMembershipManager implements RoomMembershipManager {
    readonly clientUserID: StringUserID;
    private readonly client;
    private readonly factory;
    constructor(clientUserID: StringUserID, client: MatrixSendClient, factory: RoomStateManagerFactory);
    getRoomMembershipRevisionIssuer(room: MatrixRoomID): Promise<ActionResult<RoomMembershipRevisionIssuer>>;
    getRoomMembershipEvents(room: MatrixRoomID): Promise<ActionResult<MembershipEvent[]>>;
}
//# sourceMappingURL=RoomMembershipManager.d.ts.map