"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomListResponse = void 0;
const typebox_1 = require("@sinclair/typebox");
const RoomDetailsEndpoint_1 = require("./RoomDetailsEndpoint");
exports.RoomListResponse = typebox_1.Type.Object({
    rooms: typebox_1.Type.Array(RoomDetailsEndpoint_1.RoomDetailsResponse, {
        description: 'An array of objects, each containing information about a room.',
    }),
    offset: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({ description: 'The current pagination offset in rooms.' }),
        typebox_1.Type.Null(),
    ])),
    total_rooms: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'The total number of rooms returned.',
        }),
        typebox_1.Type.Null(),
    ])),
    next_batch: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({ description: 'Token to get the next page of results.' }),
        typebox_1.Type.Null(),
    ])),
    prev_batch: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'Token to get the previous page of results.',
        }),
        typebox_1.Type.Null(),
    ])),
}, {
    description: 'The JSON response body containing room listings and pagination information.',
});
//# sourceMappingURL=RoomListEndpoint.js.map