"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDetailsResponse = void 0;
const typebox_1 = require("@sinclair/typebox");
exports.UserDetailsResponse = typebox_1.Type.Object({
    name: typebox_1.Type.String({
        description: 'Fully-qualified user ID (e.g., @user:server.com).',
    }),
    is_guest: typebox_1.Type.Boolean({
        description: 'Status if that user is a guest account.',
    }),
    admin: typebox_1.Type.Boolean({
        description: 'Status if that user is a server administrator.',
    }),
    user_type: typebox_1.Type.Union([typebox_1.Type.Literal('support'), typebox_1.Type.Literal('bot'), typebox_1.Type.Null()], {
        description: "Type of the user. Normal users are type null. Other possible types include 'support' and 'bot'.",
    }),
    deactivated: typebox_1.Type.Boolean({
        description: 'Status if that user has been marked as deactivated.',
    }),
    erased: typebox_1.Type.Boolean({
        description: 'Status if that user has been marked as erased.',
    }),
    shadow_banned: typebox_1.Type.Boolean({
        description: 'Status if that user has been marked as shadow banned.',
    }),
    displayname: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: "The user's display name if they have set one.",
    })),
    avatar_url: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: "The user's avatar URL if they have set one.",
    })),
    creation_ts: typebox_1.Type.Integer({
        description: "The user's creation timestamp in ms.",
    }),
    last_seen_ts: typebox_1.Type.Integer({
        description: "The user's last activity timestamp in ms.",
    }),
    locked: typebox_1.Type.Boolean({
        description: 'Status if that user has been marked as locked.',
    }),
    suspended: typebox_1.Type.Boolean({
        description: 'Whether the user is suspended',
    }),
});
//# sourceMappingURL=UserDetailsEndpoint.js.map