import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomEvent } from '../MatrixTypes/Events';
type RoomPauseTaskCB = () => Promise<unknown>;
type RoomPauseThenCB = (roomID: StringRoomID, event: RoomEvent) => void;
/**
 * The room pauser allows `ClientRooms` to pause the processing of certain
 * rooms while we ensure a number of conditions about the room:
 * 1. That we are joined to the room.
 * 2. That we have available room state in the room state manager for the room.
 * 3. And that all member information is up to date.
 * 4. And that all policy information is up to date.
 * A room that is paused will still report isJoined.
 *
 * If informed of another membership event after pausing a room,
 * it will just end up in the pause queue.
 *
 * While We don't need to call joined_members to verify that we are joined to a room
 * upon seeing a join event (so long as we allow spurios joins from failing
 * to detect profile updates. The homeserver shouldn't be wrong about its own
 * membership.). I don't feel quite so confident that the bot can stay in sync.
 */
export interface RoomPauser {
    isRoomPaused(roomID: StringRoomID): boolean;
    pauseRoom(roomID: StringRoomID, task: RoomPauseTaskCB, then: RoomPauseThenCB): void;
    handleTimelineEventInPausedRoom(roomID: StringRoomID, event: RoomEvent): void;
}
export declare class StandardRoomPauser implements RoomPauser {
    private readonly pausedRooms;
    isRoomPaused(roomID: StringRoomID): boolean;
    private unpause;
    pauseRoom(roomID: StringRoomID, task: RoomPauseTaskCB, then: RoomPauseThenCB): void;
    handleTimelineEventInPausedRoom(roomID: StringRoomID, event: RoomEvent): void;
}
export {};
//# sourceMappingURL=RoomPauser.d.ts.map