import { TObject, TSchema } from '@sinclair/typebox';
import { EDStatic } from '../Interface/Static';
import { Result } from '@gnuxie/typescript-result';
import { ConfigParseError } from './ConfigParseError';
import { ConfigMirror } from './ConfigMirror';
type StaticProperties<T extends TSchema, P extends unknown[] = []> = (T & {
    params: P;
})['params'];
export type UnknownProperties<T extends TSchema> = {
    [K in keyof StaticProperties<T>]: unknown;
};
export declare const UnknownConfig: TObject<{}>;
export type UnknownConfig = typeof UnknownConfig;
export type ConfigPropertyDescription = {
    path: string;
    name: string;
    description: string | undefined;
    default: unknown;
    isArray: boolean;
    isUniqueItems: boolean;
};
export type ConfigDescription<TConfigSchema extends TObject = TObject> = {
    readonly schema: TConfigSchema;
    parseConfig(config: unknown): Result<EDStatic<TConfigSchema>, ConfigParseError>;
    parseJSONConfig(config: unknown): Result<UnknownProperties<TConfigSchema>>;
    properties(): ConfigPropertyDescription[];
    getPropertyDescription(key: string): ConfigPropertyDescription;
    toMirror(): ConfigMirror<TConfigSchema>;
    getDefaultConfig(): EDStatic<TConfigSchema>;
};
export declare class StandardConfigDescription<TConfigSchema extends TObject> implements ConfigDescription<TConfigSchema> {
    readonly schema: TConfigSchema;
    constructor(schema: TConfigSchema);
    parseConfig(config: unknown): Result<EDStatic<TConfigSchema>, ConfigParseError>;
    parseJSONConfig(config: unknown): Result<UnknownProperties<TConfigSchema>>;
    properties(): ConfigPropertyDescription[];
    getPropertyDescription(key: string): ConfigPropertyDescription;
    toMirror(): ConfigMirror<TConfigSchema>;
    getDefaultConfig(): EDStatic<TConfigSchema>;
}
export {};
//# sourceMappingURL=ConfigDescription.d.ts.map