import { ActionError, ActionResult } from './Action';
import { ActionException, ActionExceptionKind } from './ActionException';
export declare class MatrixException extends ActionException implements ActionError {
    readonly matrixErrorCode: string;
    readonly matrixErrorMessage: string;
    constructor(exception: unknown, matrixErrorCode: string, matrixErrorMessage: string, message?: string, kind?: ActionExceptionKind);
    /**
     * Result wrapper, @see ActionError.
     * Named because of https://github.com/microsoft/TypeScript/issues/4628.
     */
    static R(options: {
        exception: Error;
        exceptionKind?: ActionExceptionKind;
        matrixErrorCode: string;
        matrixErrorMessage: string;
        /** Message will usually include context from the http client such as the endpoint used. */
        message: string;
    }): ActionResult<never, MatrixException>;
}
//# sourceMappingURL=MatrixException.d.ts.map