/**
 * An interface for any object that provides a logging capability.
 * @see {@link setGlobalLoggerProvider}.
 */
export interface ILoggerProvider {
    debug(moduleName: string, message: string, ...parts: unknown[]): void;
    info(moduleName: string, message: string, ...parts: unknown[]): void;
    warn(moduleName: string, message: string, ...parts: unknown[]): void;
    error(moduleName: string, message: string, ...parts: unknown[]): void;
}
/**
 * This is a utility used throughout the library to provide generic logging
 * capability without being tied to one provider or logging implementation.
 * @see {@link setGlobalLoggerProvider}
 */
export declare class Logger implements ILoggerProvider {
    readonly moduleName: string;
    constructor(moduleName: string);
    debug(message: string, ...parts: unknown[]): void;
    info(message: string, ...parts: unknown[]): void;
    warn(message: string, ...parts: unknown[]): void;
    error(message: string, ...parts: unknown[]): void;
}
/**
 * Allows the provider for all instances of `Logger` to be set.
 * @param provider An object that implements `ILoggerProvider`.
 * @see {@link ILoggerProvider}.
 */
export declare function setGlobalLoggerProvider(provider: ILoggerProvider): void;
//# sourceMappingURL=Logger.d.ts.map