import { Static } from '@sinclair/typebox';
import { StringUserID } from '@the-draupnir-project/matrix-basic-types';
export type RoomCreateOptions = Static<typeof RoomCreateOptions>;
export declare const RoomCreateOptions: import("@sinclair/typebox").TObject<{
    visibility: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TLiteral<"public">, import("@sinclair/typebox").TLiteral<"private">]>>;
    room_alias_name: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    name: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    topic: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    invite: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>>;
    invite_3pid: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TArray<import("@sinclair/typebox").TObject<{
        id_server: import("@sinclair/typebox").TString;
        id_access_token: import("@sinclair/typebox").TString;
        medium: import("@sinclair/typebox").TString;
        address: import("@sinclair/typebox").TString;
    }>>>;
    room_version: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    creation_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        type: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>>;
    initial_state: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TArray<import("@sinclair/typebox").TObject<{
        type: import("@sinclair/typebox").TString;
        state_key: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        content: import("@sinclair/typebox").TUnknown;
    }>>>;
    preset: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TLiteral<"private_chat">, import("@sinclair/typebox").TLiteral<"public_chat">, import("@sinclair/typebox").TLiteral<"trusted_private_chat">]>>;
    is_direct: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TBoolean>;
    power_level_content_override: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        ban: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        events: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TNumber>>;
        events_default: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        invite: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        kick: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redact: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        state_default: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        users: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TRecord<import("@sinclair/typebox").TString, import("@sinclair/typebox").TNumber>>;
        users_default: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        notifications: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
            room: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        }>>;
    }>>;
}>;
export type RoomCreateContent = Static<typeof RoomCreateContent>;
export declare const RoomCreateContent: import("@sinclair/typebox").TObject<{
    creator: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    'm.federate': import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TBoolean>;
    room_version: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    type: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    predecessor: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        room_id: import("@sinclair/typebox").TString;
        event_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
    }>>;
    additional_creators: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TArray<import("@sinclair/typebox").TUnsafe<StringUserID>>>;
}>;
export type RoomCreateEvent = Static<typeof RoomCreateEvent>;
export declare const RoomCreateEvent: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    content: import("@sinclair/typebox").TObject<{
        creator: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        'm.federate': import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TBoolean>;
        room_version: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        type: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        predecessor: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
            room_id: import("@sinclair/typebox").TString;
            event_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        }>>;
        additional_creators: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TArray<import("@sinclair/typebox").TUnsafe<StringUserID>>>;
    }>;
}>, import("@sinclair/typebox").TObject<{
    event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
    sender: import("@sinclair/typebox").TUnsafe<StringUserID>;
    origin_server_ts: import("@sinclair/typebox").TNumber;
    unsigned: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TObject<{
        age: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TNumber>;
        redacted_because: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
        transaction_id: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TString>;
        prev_content: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnknown>;
    }>>;
}>]>, import("@sinclair/typebox").TObject<{
    room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
}>]>, import("@sinclair/typebox").TObject<{}>]>, import("@sinclair/typebox").TObject<{
    state_key: import("@sinclair/typebox").TString;
    type: import("@sinclair/typebox").TLiteral<"m.room.create">;
}>]>;
export declare const RoomVersionMirror: Readonly<{
    isVersionWithPrivilidgedCreators(versionSpecifier: string): boolean;
    isUserAPrivilidgedCreator(userID: StringUserID, creationEvent: RoomCreateEvent): boolean;
    priviligedCreators(creationEvent: RoomCreateEvent): StringUserID[];
}>;
//# sourceMappingURL=CreateRoom.d.ts.map