"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultEventDecoder = void 0;
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const Value_1 = require("../Interface/Value");
const PolicyListRevision_1 = require("../PolicyList/PolicyListRevision");
const SafeMembershipEvent_1 = require("../SafeMatrixEvents/SafeMembershipEvent");
const UndecodableEventContent_1 = require("../SafeMatrixEvents/UndecodableEventContent");
const CreateRoom_1 = require("./CreateRoom");
const EventDecoder_1 = require("./EventDecoder");
const JoinRules_1 = require("./JoinRules");
const PolicyEvents_1 = require("./PolicyEvents");
const PowerLevels_1 = require("./PowerLevels");
const ReactionEvent_1 = require("./ReactionEvent");
const Redaction_1 = require("./Redaction");
const RoomMessage_1 = require("./RoomMessage");
const ServerACL_1 = require("./ServerACL");
const Tombstone_1 = require("./Tombstone");
let eventDecoder = EventDecoder_1.StandardEventDecoder.blankEventDecoder()
    .setDecoderForInvalidEventContent(UndecodableEventContent_1.decodeEventWithUndecodableContent)
    .setDecoderForEventType(PolicyListRevision_1.MJOLNIR_SHORTCODE_EVENT_TYPE, (event) => Value_1.Value.Decode(PolicyListRevision_1.MjolnirShortcodeEvent, event))
    .setDecoderForEventType('m.reaction', (event) => Value_1.Value.Decode(ReactionEvent_1.ReactionEvent, event))
    .setDecoderForEventType('m.room.create', (event) => Value_1.Value.Decode(CreateRoom_1.RoomCreateEvent, event))
    .setDecoderForEventType('m.room.redaction', (event) => Value_1.Value.Decode(Redaction_1.Redaction, event))
    .setDecoderForEventType('m.room.join_rules', (event) => Value_1.Value.Decode(JoinRules_1.JoinRulesEvent, event))
    .setDecoderForEventType('m.room.member', SafeMembershipEvent_1.SafeMembershipEventMirror.parseEvent)
    .setDecoderForEventType('m.room.message', (event) => Value_1.Value.Decode(RoomMessage_1.RoomMessage, event))
    .setDecoderForEventType('m.room.power_levels', (event) => Value_1.Value.Decode(PowerLevels_1.PowerLevelsEvent, event))
    .setDecoderForEventType('m.room.server_acl', (event) => Value_1.Value.Decode(ServerACL_1.ServerACLEvent, event))
    .setDecoderForEventType('m.room.tombstone', (event) => Value_1.Value.Decode(Tombstone_1.TombstoneEvent, event));
for (const type of PolicyEvents_1.ALL_RULE_TYPES) {
    eventDecoder = eventDecoder.setDecoderForEventType(type, function (event) {
        return Value_1.Value.Decode(PolicyEvents_1.PolicyRuleEvent, event);
    });
}
exports.DefaultEventDecoder = eventDecoder;
//# sourceMappingURL=DefaultEventDecoder.js.map