"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowerLevelsEvent = exports.PowerLevelsEventContent = void 0;
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2016 OpenMarket Ltd
// Copyright 2018 New Vector Ltd
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-spec
// https://github.com/matrix-org/matrix-spec
// </text>
const typebox_1 = require("@sinclair/typebox");
const Events_1 = require("./Events");
exports.PowerLevelsEventContent = typebox_1.Type.Object({
    ban: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The level required to ban a user. Defaults to 50 if unspecified.',
    })),
    events: typebox_1.Type.Optional(typebox_1.Type.Record(typebox_1.Type.String(), typebox_1.Type.Number())),
    events_default: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The default level required to send message events. Can be\noverridden by the `events` key.  Defaults to 0 if unspecified.',
    })),
    invite: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The level required to invite a user. Defaults to 0 if unspecified.',
    })),
    kick: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The level required to kick a user. Defaults to 50 if unspecified.',
    })),
    redact: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The level required to redact an event sent by another user. Defaults to 50 if unspecified.',
    })),
    state_default: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The default level required to send state events. Can be overridden\nby the `events` key. Defaults to 50 if unspecified.',
    })),
    users: typebox_1.Type.Optional(typebox_1.Type.Record(typebox_1.Type.String(), typebox_1.Type.Number())),
    users_default: typebox_1.Type.Optional(typebox_1.Type.Number({
        description: 'The power level for users in the room whose `user_id` is not mentioned in the `users` key. Defaults to 0 if\nunspecified.\n\n**Note**: When there is no `m.room.power_levels` event in the room, the room creator has\na power level of 100, and all other users have a power level of 0.     ',
    })),
    notifications: typebox_1.Type.Optional(typebox_1.Type.Object({
        room: typebox_1.Type.Optional(typebox_1.Type.Number({
            description: 'The level required to trigger an `@room` notification. Defaults to 50 if unspecified.',
        })),
    }, { additionalProperties: typebox_1.Type.Number() })),
});
exports.PowerLevelsEvent = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.StateEvent)(exports.PowerLevelsEventContent), ['state_key', 'type']),
    typebox_1.Type.Object({
        state_key: typebox_1.Type.String({
            description: 'A zero-length string.',
            pattern: '^$',
        }),
        type: typebox_1.Type.Literal('m.room.power_levels'),
    }),
]);
//# sourceMappingURL=PowerLevels.js.map