"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringEventIDSchema = exports.StringRoomAliasSchema = exports.StringRoomIDSchema = exports.StringUserIDSchema = void 0;
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2024 Haydn Paterson (sinclair) <haydn.developer@gmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typebox_1 = require("@sinclair/typebox");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
typebox_1.FormatRegistry.Set('StringUserID', matrix_basic_types_1.isStringUserID);
exports.StringUserIDSchema = typebox_1.Type.Unsafe(typebox_1.Type.String({ format: 'StringUserID' }));
typebox_1.FormatRegistry.Set('StringRoomID', matrix_basic_types_1.isStringRoomID);
exports.StringRoomIDSchema = typebox_1.Type.Unsafe(typebox_1.Type.String({ format: 'StringRoomID' }));
typebox_1.FormatRegistry.Set('StringRoomAlias', matrix_basic_types_1.isStringRoomAlias);
exports.StringRoomAliasSchema = typebox_1.Type.Unsafe(typebox_1.Type.String({ format: 'StringRoomAlias' }));
typebox_1.FormatRegistry.Set('StringEventID', matrix_basic_types_1.isStringEventID);
exports.StringEventIDSchema = typebox_1.Type.Unsafe(typebox_1.Type.String({ format: 'StringEventID' }));
//# sourceMappingURL=StringlyTypedMatrix.js.map