"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseAdminPostMakeRoomAdminRequest = exports.SynapseAdminDeleteRoomRequest = exports.SynapseAdminPostUserDeactivateRequest = exports.SynapseAdminGetUserAdminResponse = void 0;
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from synapse
// https://github.com/matrix-org/synapse
// </text>
const typebox_1 = require("@sinclair/typebox");
const StringlyTypedMatrix_1 = require("../StringlyTypedMatrix");
exports.SynapseAdminGetUserAdminResponse = typebox_1.Type.Object({
    admin: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.Null(), typebox_1.Type.Boolean()])),
});
exports.SynapseAdminPostUserDeactivateRequest = typebox_1.Type.Object({
    erase: typebox_1.Type.Optional(typebox_1.Type.Boolean({ default: false })),
});
exports.SynapseAdminDeleteRoomRequest = typebox_1.Type.Object({
    new_room_user_id: typebox_1.Type.Union([typebox_1.Type.Optional(StringlyTypedMatrix_1.StringUserIDSchema)], {
        description: ' If set, a new room will be created with this user ID as the creator and admin, and all users in the old room will be moved into that room. If not set, no new room will be created and the users will just be removed from the old room. The user ID must be on the local server, but does not necessarily have to belong to a registered user.',
    }),
    room_name: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'A string representing the name of the room that new users will be invited to. Defaults to Content Violation Notification',
    })),
    message: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'A string containing the first message that will be sent as new_room_user_id in the new room. Ideally this will clearly convey why the original room was shut down. Defaults to Sharing illegal content on this server is not permitted and rooms in violation will be blocked.',
    })),
    block: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: 'block - Optional. If set to true, this room will be added to a blocking list, preventing future attempts to join the room. Defaults to true. Defaults to false in Synapse (annoyingly)',
        default: true,
    })),
    purge: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: 'If set to true, it will remove all traces of the room from your database. Defaults to true.',
        default: true,
    })),
    force_purge: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: "Optional, and ignored unless purge is true. If set to true, it will force a purge to go ahead even if there are local users still in the room. Do not use this unless a regular purge operation fails, as it could leave those users' clients in a confused state.",
        default: false,
    })),
});
exports.SynapseAdminPostMakeRoomAdminRequest = typebox_1.Type.Object({
    user_id: StringlyTypedMatrix_1.StringUserIDSchema,
});
//# sourceMappingURL=APIBodies.js.map