"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomStateMembershipRevisionIssuer = void 0;
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const events_1 = __importDefault(require("events"));
/**
 * An implementation of the {@link RoomMembershipRevisionIssuer} that
 * uses the {@link RoomStateRevisionIssuer}.
 */
class RoomStateMembershipRevisionIssuer extends events_1.default {
    constructor(room, currentRevision, roomStateRevisionIssuer) {
        super();
        this.room = room;
        this.currentRevision = currentRevision;
        this.roomStateRevisionIssuer = roomStateRevisionIssuer;
        this.stateRevisionListener = this.listener.bind(this);
        this.roomStateRevisionIssuer.on('revision', this.stateRevisionListener);
    }
    updateForMembershipEvent(event) {
        if (this.currentRevision.hasEvent(event.event_id)) {
            return;
        }
        this.roomStateRevisionIssuer.updateForEvent(event);
    }
    updateForRedactionEvent(event) {
        this.roomStateRevisionIssuer.updateForRedaction(event);
    }
    listener(_stateRevision, stateChanges) {
        const membershipEvents = stateChanges
            .filter((change) => change.eventType === 'm.room.member')
            .map((change) => change.state);
        const membershipChanges = this.currentRevision.changesFromMembership(membershipEvents);
        const previousRevision = this.currentRevision;
        this.currentRevision =
            previousRevision.reviseFromChanges(membershipChanges);
        this.emit('revision', this.currentRevision, membershipChanges, previousRevision);
    }
    unregisterListeners() {
        this.roomStateRevisionIssuer.off('revision', this.stateRevisionListener);
    }
}
exports.RoomStateMembershipRevisionIssuer = RoomStateMembershipRevisionIssuer;
//# sourceMappingURL=RoomStateMembershipRevisionIssuer.js.map