import EventEmitter from 'events';
import { SetMembershipRevision, SetMembershipDelta } from './SetMembershipRevision';
import { SetRoomMembership } from './SetRoomMembership';
export type SetMembershipRevisionListener = (nextRevision: SetMembershipRevision, changes: SetMembershipDelta, previousRevision: SetMembershipRevision) => void;
export interface SetMembershipRevisionIssuer {
    readonly currentRevision: SetMembershipRevision;
    on(event: 'revision', listener: SetMembershipRevisionListener): this;
    off(event: 'revision', listener: SetMembershipRevisionListener): this;
    emit(event: 'revision', ...args: Parameters<SetMembershipRevisionListener>): boolean;
    unregisterListeners(): void;
}
export declare class StandardSetMembershipRevisionIssuer extends EventEmitter implements SetMembershipRevisionIssuer {
    private readonly setRoomMembershipIssuer;
    currentRevision: SetMembershipRevision;
    private readonly roomMembershipRevisionListener;
    private readonly setRoomChangeListener;
    constructor(setRoomMembershipIssuer: SetRoomMembership);
    unregisterListeners(): void;
    private membershipRevision;
    private setRoomChange;
}
//# sourceMappingURL=SetMembershipRevisionIssuer.d.ts.map