"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardRoomMembershipRevisionIssuer = void 0;
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const events_1 = __importDefault(require("events"));
const Logger_1 = require("../Logging/Logger");
const Action_1 = require("../Interface/Action");
const EventBatch_1 = require("../StateTracking/EventBatch");
const log = new Logger_1.Logger('StandardRoomMembershipRevisionIssuer');
/**
 * Users of this class are strongly recommended to consider the
 * RoomState based alternative `RoomStateMembershipRevisionIssuer`.
 * This class will likely be removed shortly.
 */
class StandardRoomMembershipRevisionIssuer extends events_1.default {
    constructor(room, currentRevision, roomMembershipManager) {
        super();
        this.room = room;
        this.currentRevision = currentRevision;
        this.roomMembershipManager = roomMembershipManager;
        this.batchCompleteCallback = this.createBatchedRevision.bind(this);
        this.currentBatch = new EventBatch_1.ConstantPeriodEventBatch(this.batchCompleteCallback, {});
    }
    addToBatch(event) {
        if (this.currentBatch.isFinished()) {
            this.currentBatch = new EventBatch_1.ConstantPeriodEventBatch(this.batchCompleteCallback, {});
        }
        this.currentBatch.addEvent(event);
    }
    updateForMembershipEvent(event) {
        if (this.currentRevision.hasEvent(event.event_id)) {
            return;
        }
        this.addToBatch(event);
    }
    updateForRedactionEvent(event) {
        this.addToBatch(event);
    }
    async createBatchedRevision() {
        const currentRoomMembershipResult = await this.roomMembershipManager.getRoomMembershipEvents(this.room);
        if ((0, Action_1.isError)(currentRoomMembershipResult)) {
            log.error(`Unable to fetch members from the room ${this.room.toPermalink()}.`, currentRoomMembershipResult.error);
            return;
        }
        const previousRevision = this.currentRevision;
        const changes = this.currentRevision.changesFromMembership(currentRoomMembershipResult.ok);
        this.currentRevision = this.currentRevision.reviseFromChanges(changes);
        this.emit('revision', this.currentRevision, changes, previousRevision);
    }
    unregisterListeners() {
        // nothing to do.
    }
}
exports.StandardRoomMembershipRevisionIssuer = StandardRoomMembershipRevisionIssuer;
//# sourceMappingURL=StandardRoomMembershipRevisionIssuer.js.map