import { ALL_RULE_TYPES, PolicyRuleEvent, PolicyRuleType, UnredactedPolicyContent } from '../MatrixTypes/PolicyEvents';
export type PolicyRuleEventDescription = {
    state_key: string;
    type: (typeof ALL_RULE_TYPES)[number];
    policyRuleType: PolicyRuleType;
    content: UnredactedPolicyContent | Record<string, never>;
};
export type DescribeBuildPolicyEvent = {
    state_key?: string | undefined;
    type?: (typeof ALL_RULE_TYPES)[number] | undefined;
    content?: UnredactedPolicyContent | undefined;
    copyFrom?: PolicyRuleEvent | undefined;
    remove?: PolicyRuleEvent | undefined;
};
export declare function policyStateKeyFromContent(content: UnredactedPolicyContent): string;
export declare function buildPolicyEvent({ state_key, type, content, copyFrom, remove, }: DescribeBuildPolicyEvent): PolicyRuleEventDescription;
//# sourceMappingURL=PolicyRuleEventBuilder.d.ts.map