import { PolicyRuleEvent, PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { EntityMatchOptions, MjolnirShortcodeEvent, PolicyRoomRevision } from './PolicyListRevision';
import { HashedLiteralPolicyRule, LiteralPolicyRule, PolicyRule, Recommendation } from './PolicyRule';
import { PolicyRuleChange } from './PolicyRuleChange';
import { Revision } from './Revision';
import { Map as PersistentMap, List as PersistentList } from 'immutable';
import { PowerLevelsEvent } from '../MatrixTypes/PowerLevels';
import { MatrixRoomID, StringEventID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
/**
 * A map interning rules by their rule type, and then their state key.
 */
type PolicyRuleMap = PersistentMap<PolicyRuleType, PersistentMap<string, PolicyRule>>;
/**
 * A map interning rules by their event id.
 */
type PolicyRuleByEventIDMap = PersistentMap<string, PolicyRule>;
type PolicyRuleByHashMap = PersistentMap<string, PersistentList<HashedLiteralPolicyRule>>;
/**
 * A standard implementation of a `PolicyListRevision` using immutable's persistent maps.
 */
export declare class StandardPolicyRoomRevision implements PolicyRoomRevision {
    readonly room: MatrixRoomID;
    readonly revisionID: Revision;
    readonly shortcode: undefined | string;
    /**
     * A map of state events indexed first by state type and then state keys.
     */
    private readonly policyRules;
    /**
     * Allow us to detect whether we have updated the state for this event.
     */
    private readonly policyRuleByEventId;
    private readonly policyRuleBySHA256;
    private readonly powerLevelsEvent;
    /**
     * Use {@link StandardPolicyRoomRevision.blankRevision} to get started.
     * Only use this constructor if you are implementing a variant of PolicyListRevision.
     * @param revisionID A revision ID to represent this revision.
     * @param policyRules A map containing the rules for this revision by state type and then state key.
     * @param policyRuleByEventId A map containing the rules ofr this revision by event id.
     */
    constructor(room: MatrixRoomID, revisionID: Revision, shortcode: undefined | string, 
    /**
     * A map of state events indexed first by state type and then state keys.
     */
    policyRules: PolicyRuleMap, 
    /**
     * Allow us to detect whether we have updated the state for this event.
     */
    policyRuleByEventId: PolicyRuleByEventIDMap, policyRuleBySHA256: PolicyRuleByHashMap, powerLevelsEvent: PowerLevelsEvent | undefined);
    /**
     * @returns An empty revision.
     */
    static blankRevision(room: MatrixRoomID): StandardPolicyRoomRevision;
    isBlankRevision(): boolean;
    /**
     * Lookup the current rules cached for the list.
     * @param stateType The event type e.g. m.policy.rule.user.
     * @param stateKey The state key e.g. rule:@bad:matrix.org
     * @returns A state event if present or null.
     */
    getPolicyRule(stateType: PolicyRuleType, stateKey: string): PolicyRule | undefined;
    allRules(): PolicyRule[];
    allRulesMatchingEntity(entity: string, { recommendation, type: ruleKind, searchHashedRules, }: Partial<EntityMatchOptions>): PolicyRule[];
    findRulesMatchingHash(hash: string, algorithm: string, { type, recommendation, }: Partial<Pick<EntityMatchOptions, 'recommendation'>> & Pick<EntityMatchOptions, 'type'>): HashedLiteralPolicyRule[];
    findRuleMatchingEntity(entity: string, { recommendation, type, searchHashedRules }: EntityMatchOptions): PolicyRule | undefined;
    allRulesOfType(type: PolicyRuleType, recommendation?: Recommendation): PolicyRule[];
    reviseFromChanges(changes: PolicyRuleChange[]): StandardPolicyRoomRevision;
    hasEvent(eventId: string): boolean;
    hasPolicy(eventID: StringEventID): boolean;
    getPolicy(eventID: StringEventID): PolicyRule | undefined;
    /**
     * Calculate the changes from this revision with a more recent set of state events.
     * Will only show the difference, if the set is the same then no changes will be returned.
     * @param state The state events that reflect a different revision of the list.
     * @returns Any changes between this revision and the new set of state events.
     */
    changesFromState(state: PolicyRuleEvent[]): PolicyRuleChange[];
    changesFromRevealedPolicies(policies: LiteralPolicyRule[]): PolicyRuleChange[];
    reviseFromState(policyState: PolicyRuleEvent[]): PolicyRoomRevision;
    isAbleToEdit(who: StringUserID, policy: PolicyRuleType): boolean;
    reviseFromPowerLevels(powerLevels: PowerLevelsEvent): PolicyRoomRevision;
    reviseFromShortcode(event: MjolnirShortcodeEvent): PolicyRoomRevision;
}
export {};
//# sourceMappingURL=StandardPolicyRoomRevision.d.ts.map