"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListMultiMap = void 0;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
const immutable_1 = require("immutable");
exports.ListMultiMap = Object.freeze({
    add(map, key, value) {
        const existing = map.get(key, (0, immutable_1.List)());
        return map.set(key, existing.push(value));
    },
    remove(map, key, value) {
        const existing = map.get(key, (0, immutable_1.List)());
        const updated = existing.filter((item) => item !== value);
        return updated.size === 0 ? map.delete(key) : map.set(key, updated);
    },
    removeValues(map, remove, getKeyFromValue) {
        let next = map;
        for (const item of remove) {
            next = this.remove(next, getKeyFromValue(item), item);
        }
        return next;
    },
    addValues(map, add, getKeyFromValue) {
        let next = map;
        for (const item of add) {
            next = this.add(next, getKeyFromValue(item), item);
        }
        return next;
    },
    deriveIntents(map, add, remove, getKeyFromValue) {
        const output = { intend: [], recall: [] };
        const projectedChanges = new Map();
        const accessChanges = (key) => {
            var _a, _b;
            return (_a = projectedChanges.get(key)) !== null && _a !== void 0 ? _a : ((existing) => ({
                valueCount: existing !== null && existing !== void 0 ? existing : 0,
                introduced: existing === undefined,
            }))((_b = map.get(key)) === null || _b === void 0 ? void 0 : _b.size);
        };
        for (const value of add) {
            projectedChanges.set(getKeyFromValue(value), ((change) => ((change.valueCount += 1), change))(accessChanges(getKeyFromValue(value))));
        }
        for (const value of remove) {
            projectedChanges.set(getKeyFromValue(value), ((change) => ((change.valueCount -= 1), change))(accessChanges(getKeyFromValue(value))));
        }
        for (const [key, change] of projectedChanges) {
            if (change.introduced && change.valueCount > 0) {
                output.intend.push(key);
            }
            else if (change.valueCount === 0) {
                output.recall.push(key);
            }
            else if (change.valueCount < 0) {
                throw new TypeError('Things are super wrong');
            }
        }
        return output;
    },
    empty() {
        return (0, immutable_1.Map)();
    },
});
//# sourceMappingURL=ListMultiMap.js.map