"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeCapabilitySet = initializeCapabilitySet;
exports.capabilitySetEventPermissions = capabilitySetEventPermissions;
exports.capabilitySetPermissions = capabilitySetPermissions;
exports.capabilitySetStatePermissions = capabilitySetStatePermissions;
const CapabilityRenderer_1 = require("./CapabilityRenderer");
function initializeCapabilitySet(protectionDescription, capabilityDescriptions, context) {
    const set = {};
    for (const [name, description] of Object.entries(capabilityDescriptions)) {
        Object.assign(set, {
            [name]: (0, CapabilityRenderer_1.wrapCapabilityProviderInRenderer)(protectionDescription, context, description),
        });
    }
    return set;
}
function capabilitySetEventPermissions(set) {
    return Object.entries(set).reduce((acc, [_name, capability]) => [
        ...acc,
        ...capability.requiredEventPermissions,
    ], []);
}
function capabilitySetPermissions(set) {
    return Object.entries(set).reduce((acc, [_name, capability]) => [...acc, ...capability.requiredPermissions], []);
}
function capabilitySetStatePermissions(set) {
    return Object.entries(set).reduce((acc, [_name, capability]) => [
        ...acc,
        ...capability.requiredStatePermissions,
    ], []);
}
//# sourceMappingURL=CapabilitySet.js.map