import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { ActionResult } from '../../../Interface/Action';
export interface SetResult {
    readonly isEveryResultOk: boolean;
    readonly numberOfFailedResults: number;
}
export interface StringTypeResult<T extends string> extends SetResult {
    readonly map: Map<T, ActionResult<void>>;
}
export declare class StringTypeResultBuilder<T extends string> {
    private isEveryResultOk;
    private numberOfFailedResults;
    private map;
    addResult(key: T, result: ActionResult<void>): this;
    getResult(): StringTypeResult<T>;
}
export type RoomSetResult = StringTypeResult<StringRoomID>;
export type RoomSetResultBuilder = StringTypeResultBuilder<StringRoomID>;
export declare const RoomSetResultBuilder: {
    new (): StringTypeResultBuilder<StringRoomID>;
};
export type ResultForUsersInRoom = StringTypeResult<StringUserID>;
export type ResultForUsersInRoomBuilder = StringTypeResultBuilder<StringUserID>;
export declare const ResultForUsersInRoomBuilder: {
    new (): StringTypeResultBuilder<StringUserID>;
};
export interface ResultForUsersInSet extends SetResult {
    readonly map: Map<StringUserID, RoomSetResult>;
}
export declare class ResultForUsersInSetBuilder {
    private isEveryResultOk;
    private numberOfFailedResults;
    private map;
    addResult(userID: StringUserID, roomID: StringRoomID, result: ActionResult<void>): this;
    getResult(): ResultForUsersInSet;
}
//# sourceMappingURL=RoomSetResult.d.ts.map