import { ActionResult } from '../../../Interface/Action';
import { Capability } from '../CapabilityProvider';
import { RoomSetResult } from './RoomSetResult';
import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { PolicyListRevisionIssuer } from '../../../PolicyList/PolicyListRevisionIssuer';
export type ResultForServerInSetMap = Map<StringRoomID, ActionResult<void>>;
/**
 * This started as a generic capability provider to serve as an example
 * for others. But it really isn't generic at all and is quite specific
 * to the serverBanSynchronisation protection and server ACL.
 */
export interface ServerConsequences extends Capability {
    /**
     * Take a consequence against a server in a room.
     * Returns true if the consequence was enacted or false if the consequence was
     * already in effect (like the server already being in the room's deny ACL).
     */
    consequenceForServersInRoom(roomID: StringRoomID, revisionIssuer: PolicyListRevisionIssuer): Promise<ActionResult<boolean>>;
    consequenceForServersInRoomSet(revisionIssuer: PolicyListRevisionIssuer): Promise<ActionResult<RoomSetResult>>;
    unbanServerFromRoomSet(serverName: string, reason: string): Promise<ActionResult<RoomSetResult>>;
}
export declare const ServerConsequences: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    consequenceForServersInRoom: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    consequenceForServersInRoomSet: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    unbanServerFromRoomSet: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
}>, import("@sinclair/typebox").TObject<{
    requiredPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredEventPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredStatePermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
}>]>;
//# sourceMappingURL=ServerConsequences.d.ts.map