"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimulatedEventConsequences = void 0;
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const CapabilityProvider_1 = require("../CapabilityProvider");
const StandardEventConsequences_1 = require("./StandardEventConsequences");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const FakeEventRedacter = Object.freeze({
    redactEvent(_room, _eventID, _reason) {
        return Promise.resolve((0, typescript_result_1.Ok)((0, EventGeneration_1.randomEventID)()));
    },
});
class SimulatedEventConsequences {
    constructor() {
        this.requiredPermissions = [];
        this.requiredEventPermissions = [];
        this.requiredStatePermissions = [];
        this.isSimulated = true;
        this.simulatedCapability = new StandardEventConsequences_1.StandardEventConsequences(FakeEventRedacter);
    }
    async consequenceForEvent(roomID, eventID, reason) {
        return await this.simulatedCapability.consequenceForEvent(roomID, eventID, reason);
    }
}
exports.SimulatedEventConsequences = SimulatedEventConsequences;
(0, CapabilityProvider_1.describeCapabilityProvider)({
    name: 'SimulatedEventConsequences',
    description: 'Simulates redacting events in protected rooms, but has no real effects',
    interface: 'EventConsequences',
    isSimulated: true,
    factory(_description, _context) {
        return new SimulatedEventConsequences();
    },
});
//# sourceMappingURL=SimulatedEventConsequences.js.map