import { ProtectedRoomsConfig } from './ProtectedRoomsConfig';
import { ActionResult } from '../../Interface/Action';
import { StringRoomID, MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { ResultError } from '@gnuxie/typescript-result';
export declare class AbstractProtectedRoomsConfig implements Omit<ProtectedRoomsConfig, 'addRoom' | 'removeRoom' | 'reportUseError'> {
    private readonly protectedRooms;
    constructor(rooms: MatrixRoomID[]);
    getProtectedRooms(): MatrixRoomID[];
    isProtectedRoom(roomID: StringRoomID): boolean;
    getProtectedRoom(roomID: StringRoomID): MatrixRoomID | undefined;
    protected addRoom(room: MatrixRoomID): void;
    protected removeRoom(room: MatrixRoomID): void;
}
export declare class FakeProtectedRoomsConfig extends AbstractProtectedRoomsConfig implements ProtectedRoomsConfig {
    constructor(rooms: MatrixRoomID[]);
    addRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    removeRoom(room: MatrixRoomID): Promise<ActionResult<void>>;
    reportUseError(_message: string, _room: MatrixRoomID, error: ResultError): Promise<ActionResult<never>>;
}
//# sourceMappingURL=FakeProtectedRoomsConfig.d.ts.map