"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MjolnirProtectedRoomsDescription = void 0;
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typebox_1 = require("@sinclair/typebox");
const describeConfig_1 = require("../../Config/describeConfig");
const StringlyTypedMatrix_1 = require("../../MatrixTypes/StringlyTypedMatrix");
exports.MjolnirProtectedRoomsDescription = (0, describeConfig_1.describeConfig)({
    schema: typebox_1.Type.Object({
        // does not have `uniqueItems: true` because there was as bug where
        // the management room kept on being added to the list of protected rooms.
        // deduplication is managed by the config implementation.
        // https://github.com/Gnuxie/matrix-protection-suite/blob/de249c4cb81290aa1081f440af16f0cadc3522d0/src/Protection/ProtectedRoomsConfig/ProtectedRoomsConfig.ts#L108
        rooms: typebox_1.Type.Array(StringlyTypedMatrix_1.StringRoomIDSchema, { default: [] }),
    }, { title: 'ProtectedRoomsConfig' }),
});
//# sourceMappingURL=MjolnirProtectedRoomsDescription.js.map