import { TObject } from '@sinclair/typebox';
import { ProtectionDescription } from '../../Protection';
import { ProtectionSettingsConfig } from './ProtectionSettingsConfig';
import { Result } from '@gnuxie/typescript-result';
import { PersistentConfigBackend } from '../../../Config/PersistentConfigData';
import { UnknownConfig } from '../../../Config/ConfigDescription';
import { EDStatic } from '../../../Interface/Static';
export type MakePersistentConfigBackendForMjolnirProtectionSettings = (protectionDescription: ProtectionDescription) => Result<PersistentConfigBackend>;
export declare class MjolnirProtectionSettingsConfig implements ProtectionSettingsConfig {
    private readonly makePersistentConfigBackend;
    constructor(makePersistentConfigBackend: MakePersistentConfigBackendForMjolnirProtectionSettings);
    storeProtectionSettings(protectionDescription: ProtectionDescription, settings: Record<string, unknown>): Promise<Result<void>>;
    getProtectionSettings<TConfigSchema extends TObject = UnknownConfig>(protectionDescription: ProtectionDescription): Promise<Result<EDStatic<TConfigSchema>>>;
}
//# sourceMappingURL=MjolnirProtectionSettingsConfig.d.ts.map