"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MjolnirProtectionSettingsConfig = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const PersistentConfigData_1 = require("../../../Config/PersistentConfigData");
class MjolnirProtectionSettingsConfig {
    constructor(makePersistentConfigBackend) {
        this.makePersistentConfigBackend = makePersistentConfigBackend;
        // nothing to do mare.
    }
    async storeProtectionSettings(protectionDescription, settings) {
        const persistentConfigBackend = this.makePersistentConfigBackend(protectionDescription);
        if ((0, typescript_result_1.isError)(persistentConfigBackend)) {
            return persistentConfigBackend;
        }
        const persistentConfigData = new PersistentConfigData_1.StandardPersistentConfigData(protectionDescription.protectionSettings, persistentConfigBackend.ok);
        return await persistentConfigData.saveConfig(settings);
    }
    async getProtectionSettings(protectionDescription) {
        const persistentConfigBackend = this.makePersistentConfigBackend(protectionDescription);
        if ((0, typescript_result_1.isError)(persistentConfigBackend)) {
            return persistentConfigBackend;
        }
        const persistentConfigData = new PersistentConfigData_1.StandardPersistentConfigData(protectionDescription.protectionSettings, persistentConfigBackend.ok);
        const result = await persistentConfigData.requestParsedConfig();
        if ((0, typescript_result_1.isError)(result)) {
            return result;
        }
        if (result.ok === undefined) {
            return (0, typescript_result_1.Ok)(protectionDescription.protectionSettings.getDefaultConfig());
        }
        return result;
    }
}
exports.MjolnirProtectionSettingsConfig = MjolnirProtectionSettingsConfig;
//# sourceMappingURL=MjolnirProtectionSettingsConfig.js.map