"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardMemberBanIntentProjectionNode = exports.MemberBanIntentProjectionNodeHelper = void 0;
const immutable_1 = require("immutable");
const PolicyRule_1 = require("../../../PolicyList/PolicyRule");
const ListMultiMap_1 = require("../../../Projection/ListMultiMap");
function isPolicyRelevant(policy) {
    return (policy.recommendation === PolicyRule_1.Recommendation.Ban ||
        policy.recommendation === PolicyRule_1.Recommendation.Takedown);
}
exports.MemberBanIntentProjectionNodeHelper = Object.freeze({
    reduceMembershipPolicyDelta(input) {
        const output = {
            add: [],
            remove: [],
        };
        for (const added of input.addedMemberMatches) {
            if (isPolicyRelevant(added.policy)) {
                output.add.push(added);
            }
        }
        for (const removed of input.removedMemberMatches) {
            if (isPolicyRelevant(removed.policy)) {
                output.remove.push(removed);
            }
        }
        return output;
    },
    reduceIntentDelta(input, policies) {
        const intents = ListMultiMap_1.ListMultiMap.deriveIntents(policies, input.add.map((match) => match.policy), input.remove.map((match) => match.policy), (rule) => rule.entity);
        return {
            ...input,
            ban: intents.intend,
            recall: intents.recall,
        };
    },
});
// Upstream inputs are not yet converted to projections, so have to be never[]
// for now.
class StandardMemberBanIntentProjectionNode {
    constructor(ulidFactory, intents) {
        this.ulidFactory = ulidFactory;
        this.intents = intents;
        this.ulid = ulidFactory();
    }
    static create(ulidFactory) {
        return new StandardMemberBanIntentProjectionNode(ulidFactory, (0, immutable_1.Map)());
    }
    isEmpty() {
        return this.intents.isEmpty();
    }
    reduceInput(input) {
        return exports.MemberBanIntentProjectionNodeHelper.reduceIntentDelta(exports.MemberBanIntentProjectionNodeHelper.reduceMembershipPolicyDelta(input), this.intents);
    }
    reduceDelta(input) {
        let nextIntents = this.intents;
        nextIntents = ListMultiMap_1.ListMultiMap.addValues(nextIntents, input.add.map((match) => match.policy), (rule) => rule.entity);
        nextIntents = ListMultiMap_1.ListMultiMap.removeValues(nextIntents, input.remove.map((match) => match.policy), (rule) => rule.entity);
        return new StandardMemberBanIntentProjectionNode(this.ulidFactory, nextIntents);
    }
    reduceInitialInputs([membershipPolicyRevision]) {
        if (!this.isEmpty()) {
            throw new TypeError('This can only be called on an empty projection node');
        }
        const matches = membershipPolicyRevision
            .allMembersWithRules()
            .map((member) => member.policies.map((policy) => ({ userID: member.userID, policy })))
            .flat();
        return {
            add: matches,
            ban: matches.map((match) => match.userID),
            remove: [],
            recall: [],
        };
    }
    allMembersWithRules() {
        return this.intents.reduce((matches, policyRules, userID) => {
            matches.push({
                userID: userID,
                policies: policyRules.toArray(),
            });
            return matches;
        }, []);
    }
    allRulesMatchingMember(member) {
        return this.intents
            .get(member, (0, immutable_1.List)())
            .toArray();
    }
}
exports.StandardMemberBanIntentProjectionNode = StandardMemberBanIntentProjectionNode;
//# sourceMappingURL=MemberBanIntentProjectionNode.js.map