"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const EventGeneration_1 = require("../../TestUtilities/EventGeneration");
const DefaultMixinExtractor_1 = require("./DefaultMixinExtractor");
const MentionsMixin_1 = require("./MentionsMixin");
const RoomMessageBodyMixin_1 = require("./RoomMessageBodyMixin");
test('We can extract ', function () {
    const content = {
        msgtype: 'm.text',
        body: 'hello world',
        'm.mentions': { user_ids: [(0, EventGeneration_1.randomUserID)()] },
    };
    const event = {
        type: 'm.room.message',
        sender: (0, EventGeneration_1.randomUserID)(),
        room_id: (0, EventGeneration_1.randomRoomID)([]).toRoomIDOrAlias(),
        content,
    };
    const decodedEvent = DefaultMixinExtractor_1.DefaultMixinExtractor.parseEvent(event);
    const mentionsMixin = decodedEvent.findMixin(MentionsMixin_1.MentionsMixinDescription);
    if (mentionsMixin === undefined) {
        throw new TypeError('We expect to be able to decode metnions mixin from this event');
    }
    if (mentionsMixin.isErroneous) {
        throw new TypeError('The mentions mixin should not be errorneous');
    }
    expect(mentionsMixin.user_ids.length).toBe(1);
    const bodyMixin = decodedEvent.findMixin(RoomMessageBodyMixin_1.RoomMessageBodyMixinDescription);
    if (bodyMixin === undefined) {
        throw new TypeError('We should be able to get the body mixin');
    }
    if (bodyMixin.isErroneous) {
        throw new TypeError('The body mixin should be fine');
    }
    expect(bodyMixin.body).toBe('hello world');
});
//# sourceMappingURL=DefaultMixinExtractor.test.js.map