"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const Action_1 = require("../Interface/Action");
const SafeMembershipEvent_1 = require("./SafeMembershipEvent");
test('This example from a client that pollutes nulls like no tomorrow', function () {
    const unknownContent = {
        avatar_url: null,
        displayname: 'robb',
        membership: 'join',
    };
    const result = SafeMembershipEvent_1.SafeMembershipEventMirror.parse(unknownContent);
    if ((0, Action_1.isError)(result)) {
        throw new TypeError(`This should be parsable`);
    }
    const safeContent = result.ok;
    expect(safeContent.avatar_url).toBe(undefined);
    expect(safeContent.displayname).toBe(unknownContent.displayname);
    expect(safeContent.membership).toBe(unknownContent.membership);
    const unsafeContent = SafeMembershipEvent_1.SafeMembershipEventMirror.getUnsafeContent(safeContent);
    expect(unsafeContent).toBeDefined();
    if (unsafeContent === undefined) {
        throw new TypeError('unsafe content is supposed to be defined');
    }
    expect(unsafeContent['avatar_url']).toBe(null);
});
test('hidden properties do not leak', function () {
    const unknownContent = {
        avatar_url: null,
        displayname: 'robb',
        membership: 'join',
    };
    const result = SafeMembershipEvent_1.SafeMembershipEventMirror.parse(unknownContent);
    if ((0, Action_1.isError)(result)) {
        throw new TypeError(`This should be parsable`);
    }
    const safeContent = result.ok;
    expect(Object.entries(safeContent).length).toBe(2);
});
//# sourceMappingURL=SafeMembershipEvent.test.js.map