import { MatrixRoomID, MatrixRoomReference, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { ActionResult } from '../Interface/Action';
import { RoomCreateOptions } from '../MatrixTypes/CreateRoom';
import { PolicyRuleEvent, PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { FakePolicyRoomRevisionIssuer } from '../PolicyList/FakePolicyRoomRevisionIssuer';
import { PolicyRoomRevisionIssuer } from '../PolicyList/PolicyListRevisionIssuer';
import { PolicyRoomEditor } from '../PolicyList/PolicyRoomEditor';
import { PolicyRoomManager } from '../PolicyList/PolicyRoomManger';
export declare class FakePolicyRoomManager implements PolicyRoomManager {
    private readonly policyRoomRevisionIssuers;
    constructor(policyRoomRevisionIssuers?: FakePolicyRoomRevisionIssuer[]);
    createPolicyRoom(_shortcode: string, _invite: string[], _createRoomOptions: RoomCreateOptions): Promise<ActionResult<MatrixRoomID>>;
    getPolicyRoomRevisionIssuer(room: MatrixRoomID): Promise<ActionResult<PolicyRoomRevisionIssuer>>;
    getPolicyRoomEditor(_room: MatrixRoomID): Promise<ActionResult<PolicyRoomEditor>>;
    getPolicyRuleEvents(_room: MatrixRoomReference): Promise<ActionResult<PolicyRuleEvent[]>>;
    getEditablePolicyRoomIDs(_editor: StringUserID, _ruleType: PolicyRuleType): MatrixRoomID[];
    getFakePolicyRoomRevisionIssuer(room: MatrixRoomID): FakePolicyRoomRevisionIssuer;
    addIssuer(issuer: FakePolicyRoomRevisionIssuer): void;
}
//# sourceMappingURL=FakePolicyRoomManager.d.ts.map