"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakePolicyRoomManager = void 0;
const Action_1 = require("../Interface/Action");
class FakePolicyRoomManager {
    constructor(policyRoomRevisionIssuers = []) {
        this.policyRoomRevisionIssuers = new Map();
        for (const issuer of policyRoomRevisionIssuers) {
            this.policyRoomRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
        }
    }
    async createPolicyRoom(_shortcode, _invite, _createRoomOptions) {
        // Strictly, this isn't true, but i don't think we're going to use this.
        throw new TypeError(`The FakePolicyRoomManager is undable to create a policy room`);
    }
    async getPolicyRoomRevisionIssuer(room) {
        const issuer = this.policyRoomRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            return Action_1.ActionError.Result(`Cannot find the room ${room.toRoomIDOrAlias()}`);
        }
        return (0, Action_1.Ok)(issuer);
    }
    async getPolicyRoomEditor(_room) {
        // Strictly this isn't true either, it could do this if we could keep track of the
        // issuers and had access to the room state revision issuer.
        throw new TypeError(`The FakePolicyRoomManager is unable to obtain an editor for a policy room`);
    }
    async getPolicyRuleEvents(_room) {
        throw new TypeError(`The FakePolicyRoomManager is unable to obtain the policy rule events for a policy room`);
    }
    getEditablePolicyRoomIDs(_editor, _ruleType) {
        // strictly speaking, it probably can releatively easily.
        throw new TypeError(`The StubPolicyRoomManager is unable to determine which policy rooms are editable`);
    }
    // These methods are on the fake side of the policy room manager.
    getFakePolicyRoomRevisionIssuer(room) {
        const issuer = this.policyRoomRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            throw new TypeError(`You haven't yet given the room ${room.toPermalink()} to the FakePolicyRevisionIssuer`);
        }
        return issuer;
    }
    addIssuer(issuer) {
        this.policyRoomRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
    }
}
exports.FakePolicyRoomManager = FakePolicyRoomManager;
//# sourceMappingURL=FakePolicyRoomManager.js.map