"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeRoomStateManager = void 0;
const Action_1 = require("../Interface/Action");
const DeclareRoomState_1 = require("./DeclareRoomState");
class FakeRoomStateManager {
    constructor(roomStateRevisionIssuers = []) {
        this.roomStateRevisionIssuers = new Map();
        for (const issuer of roomStateRevisionIssuers) {
            this.roomStateRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
        }
    }
    async getRoomStateRevisionIssuer(room) {
        const issuer = this.roomStateRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            return Action_1.ActionError.Result(`Canont find the room ${room.toRoomIDOrAlias()}`);
        }
        else {
            return (0, Action_1.Ok)(issuer);
        }
    }
    getRoomState(_room) {
        throw new TypeError(`The FakeRoomStateManager is not capable of fetching RoomState`);
    }
    appendState({ stateDescriptions = [], membershipDescriptions = [], policyDescriptions = [], room, }) {
        const { stateEvents } = (0, DeclareRoomState_1.describeRoomStateEvents)({
            room,
            stateDescriptions,
            membershipDescriptions,
            policyDescriptions,
        });
        this.appendStateEvents(room, stateEvents);
    }
    appendStateEvents(room, stateEvents) {
        const issuer = this.roomStateRevisionIssuers.get(room.toRoomIDOrAlias());
        if (issuer === undefined) {
            throw new TypeError(`FakeRoomStateManager can't find which room you're trying to revise.`);
        }
        issuer.appendState(stateEvents);
    }
    addIssuer(issuer) {
        this.roomStateRevisionIssuers.set(issuer.room.toRoomIDOrAlias(), issuer);
    }
}
exports.FakeRoomStateManager = FakeRoomStateManager;
//# sourceMappingURL=FakeRoomStateManager.js.map