import EventEmitter from 'events';
import { SetRoomState, SetRoomStateMirrorCord } from './SetRoomState';
import { RoomStateManager, RoomStateRevision, RoomStateRevisionIssuer } from './StateRevisionIssuer';
import { ActionResult } from '../Interface/Action';
import { StringRoomID, MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
/**
 * Provides immediate (synchronous) access to the room state within a set of rooms.
 * Needs to be backed up with the ProtectedRoomManager which will add and remove rooms
 * via the `SetRoomStateMirror` as they are added and removed from the protected
 * rooms set.
 */
export declare class StandardSetRoomState extends EventEmitter implements SetRoomState {
    private readonly issuers;
    private readonly revisionListener;
    private constructor();
    getRevision(room: StringRoomID): RoomStateRevision | undefined;
    static create(roomStateManager: RoomStateManager, roomSet: MatrixRoomID[]): Promise<ActionResult<SetRoomState>>;
    static blankSet(): StandardSetRoomState;
    [SetRoomStateMirrorCord.addRoom](room: MatrixRoomID, roomStateRevisionIssuer: RoomStateRevisionIssuer): void;
    [SetRoomStateMirrorCord.removeRoom](room: MatrixRoomID): void;
    unregisterListeners(): void;
    get allRooms(): RoomStateRevision[];
    private stateRevision;
}
//# sourceMappingURL=StandardSetRoomState.d.ts.map