import type ts from 'typescript';
import type { ArrayLiteralExpression, BigIntLiteral, BinaryExpression, BinaryOperator, BinaryOperatorToken, Block, CallExpression, ColonToken, ConditionalExpression, ElementAccessExpression, OmittedExpression, Expression, ExpressionStatement, ForStatement, FunctionExpression, FunctionTypeNode, Identifier, IfStatement, ImportDeclaration, KeywordTypeNode, KeywordTypeSyntaxKind, LiteralType, MethodDeclaration, Node, NodeArray, NodeFlags, NullLiteral, NumericLiteral, ObjectLiteralElementLike, ObjectLiteralExpression, ParameterDeclaration, PostfixUnaryExpression, PostfixUnaryOperator, PrefixUnaryOperator, PrefixUnaryExpression, PrivateIdentifier, PropertyAccessExpression, PropertyAssignment, PropertyDeclaration, PropertyName, PropertySignature, PunctuationSyntaxKind, PunctuationToken, QuestionToken, ReturnStatement, SourceFile, SpreadElement, StringLiteral, TokenFlags, TypeElement, TypeLiteralNode, TypeNode, TypeQueryNode, TypeReferenceNode, VariableDeclaration, VariableDeclarationList, VariableStatement, VoidExpression } from 'typescript';
import { Statement } from 'typescript/lib/tsserverlibrary';
export declare function createArrayLiteral(elements?: readonly Expression[], multiLine?: boolean): ArrayLiteralExpression;
export declare function createVariableStatement(declarationList: VariableDeclarationList | readonly VariableDeclaration[]): VariableStatement;
export declare function createVariableDeclarationList(declarations: readonly VariableDeclaration[], flags?: NodeFlags): VariableDeclarationList;
export declare function createIdentifier(text: string): Identifier;
export declare function createNumericLiteral(value: string | number, numericLiteralFlags?: TokenFlags): NumericLiteral;
export declare function createExpressionForNegativeOrPositiveNumber(value: number): Expression;
export declare function createPrefixUnaryExpression(unaryOperator: PrefixUnaryOperator, operand: Expression): Expression;
export declare function createArrowFunction(block: ts.ConciseBody, parameter?: ReadonlyArray<ts.ParameterDeclaration>): ts.ArrowFunction;
export declare function createFunctionExpression(block: Block, parameter?: ReadonlyArray<ParameterDeclaration>): FunctionExpression;
export declare function createFunctionExpressionReturn(descriptorToReturn: Expression, parameter?: ReadonlyArray<ParameterDeclaration>): FunctionExpression;
export declare function createBlock(statements: readonly Statement[], multiLine?: boolean | undefined): Block;
export declare function createReturnStatement(expression?: Expression): ReturnStatement;
export declare function createCall(expression: Expression, argumentExpressions: Expression[]): CallExpression;
export declare function createIIFE(block: Block): CallExpression;
export declare function createEmptyProperty(): PropertyDeclaration;
export declare function createProperty(propertyName: string | PropertyName, type: TypeNode | undefined): PropertyDeclaration;
export declare function createPropertySignature(propertyName: string | PropertyName, type: TypeNode): PropertySignature;
export declare function createParameter(parameterName: string): ParameterDeclaration;
export declare function createParameterFromIdentifier(identifier: Identifier): ParameterDeclaration;
export declare function createMethod(methodName: string, body: Block, parameterNames?: Identifier[]): MethodDeclaration;
export declare function createVariableDeclaration(variableIdentifier: Identifier, initializer: Expression): VariableDeclaration;
export declare function createPropertyAccess(expression: Expression, name: string | Identifier | PrivateIdentifier): PropertyAccessExpression;
export declare function createSpread(expression: Expression): SpreadElement;
export declare function createStringLiteral(text: string): StringLiteral;
export declare function createLogicalNot(operand: Expression): PrefixUnaryExpression;
export declare function createLiteral(type: LiteralType): StringLiteral | Expression | BigIntLiteral;
export declare function createNodeArray<T extends Node>(elements?: readonly T[], hasTrailingComma?: boolean): NodeArray<T>;
export declare function createArrayTypeNode(): Node;
export declare function createTypeNode<TKind extends KeywordTypeSyntaxKind>(kind: TKind): KeywordTypeNode<TKind>;
export declare function createFunctionTypeNode(typeNode: TypeNode): FunctionTypeNode;
export declare function createObjectLiteral(properties?: readonly ObjectLiteralElementLike[], multiLine?: boolean): ObjectLiteralExpression;
export declare function createBinaryExpression(left: Expression, operator: BinaryOperator | BinaryOperatorToken, right: Expression): BinaryExpression;
export declare function createPunctuationToken<TKind extends PunctuationSyntaxKind>(token: TKind): PunctuationToken<TKind>;
export declare function createIfStatement(expression: Expression, block: Block): IfStatement;
export declare function createReturn(expression: Expression): ReturnStatement;
export declare function createExpressionStatement(binaryExpression: Expression): ExpressionStatement;
export declare function createElementAccessExpression(identifier: Identifier, literalProperty: StringLiteral): ElementAccessExpression;
export declare function createPropertyAssignment(name: string | PropertyName, expression: ts.Expression): PropertyAssignment;
export declare function createElementAccess(expression: Expression, index: number | Expression): ElementAccessExpression;
export declare function createConditional(condition: Expression, questionToken: QuestionToken | undefined, whenTrue: Expression, colonToken: ColonToken | undefined, whenFalse: Expression): ConditionalExpression;
export declare function updateSourceFileNode(node: SourceFile, statements: readonly Statement[]): SourceFile;
export declare function createImportAllAs(moduleName: ts.Identifier, filenameToImportFrom: string): ImportDeclaration;
export declare function createForStatement(initializer: Expression | VariableDeclarationList | undefined, condition: Expression | undefined, incrementor: Expression | undefined, statement: Statement): ForStatement;
export declare function createPostfix(operand: Expression, operator: PostfixUnaryOperator): PostfixUnaryExpression;
export declare function createOmittedExpression(): OmittedExpression;
export declare function createTypeReferenceNode(identifier: Identifier): TypeReferenceNode;
export declare function createNew(expression: Expression): Expression;
export declare function createNull(): NullLiteral;
export declare function createTypeQueryNode(identifier: Identifier): TypeQueryNode;
export declare function createTypeLiteralNode(typeElements: readonly TypeElement[]): TypeLiteralNode;
export declare function createVoidZero(): VoidExpression;
