"use strict";
// SPDX-FileCopyrightText: 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultEnabledProtectionsMigration = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const RedactionSynchronisation_1 = require("./RedactionSynchronisation");
const PolicyChangeNotification_1 = require("./PolicyChangeNotification");
const JoinRoomsOnInviteProtection_1 = require("./invitation/JoinRoomsOnInviteProtection");
const RoomsSetBehaviourProtection_1 = require("./ProtectedRooms/RoomsSetBehaviourProtection");
const InvalidEventProtection_1 = require("./InvalidEventProtection");
exports.DefaultEnabledProtectionsMigration = new matrix_protection_suite_1.SchemedDataManager([
    async function enableBanPropagationByDefault(input) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const banPropagationProtection = (0, matrix_protection_suite_1.findProtection)("BanPropagationProtection");
        if (banPropagationProtection === undefined) {
            const message = `Cannot find the BanPropagationProtection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        const enabled = new Set(input.enabled);
        enabled.add(banPropagationProtection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabled],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: 1,
        });
    },
    async function enableMemberAndServerSynchronisationByDefault(input) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        // we go through the process of finding them just so we can be sure that we spell their names correctly.
        const memberBanSynchronisationProtection = (0, matrix_protection_suite_1.findProtection)("MemberBanSynchronisationProtection");
        const serverBanSynchronisationProtection = (0, matrix_protection_suite_1.findProtection)("ServerBanSynchronisationProtection");
        if (memberBanSynchronisationProtection === undefined ||
            serverBanSynchronisationProtection === undefined) {
            const message = `Cannot find the member ban or server ban synchronisation protections`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        for (const protection of [
            memberBanSynchronisationProtection,
            serverBanSynchronisationProtection,
        ]) {
            enabledProtections.add(protection.name);
        }
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: 2,
        });
    },
    async function enableRedactionSynchronisationProtectionByDefault(input) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)(RedactionSynchronisation_1.RedactionSynchronisationProtection.name);
        if (protection === undefined) {
            const message = `Cannot find the ${RedactionSynchronisation_1.RedactionSynchronisationProtection.name} protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: 3,
        });
    },
    async function enablePolicyChangeNotification(input) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)(PolicyChangeNotification_1.PolicyChangeNotification.name);
        if (protection === undefined) {
            const message = `Cannot find the ${PolicyChangeNotification_1.PolicyChangeNotification.name} protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: 4,
        });
    },
    async function enableJoinRoomsOnInviteProtection(input) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)(JoinRoomsOnInviteProtection_1.JoinRoomsOnInviteProtection.name);
        if (protection === undefined) {
            const message = `Cannot find the ${JoinRoomsOnInviteProtection_1.JoinRoomsOnInviteProtection.name} protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: 5,
        });
    },
    async function enableRoomsSetBehaviourProtection(input, toVersion) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)(RoomsSetBehaviourProtection_1.RoomsSetBehaviour.name);
        if (protection === undefined) {
            const message = `Cannot find the ${RoomsSetBehaviourProtection_1.RoomsSetBehaviour.name} protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        });
    },
    async function enableInvalidEventProtection(input, toVersion) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)(InvalidEventProtection_1.InvalidEventProtection.name);
        if (protection === undefined) {
            const message = `Cannot find the ${RoomsSetBehaviourProtection_1.RoomsSetBehaviour.name} protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        });
    },
    async function enableDraupnirNews(input, toVersion) {
        if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.MjolnirEnabledProtectionsEvent, input)) {
            return matrix_protection_suite_1.ActionError.Result(`The data for ${matrix_protection_suite_1.MjolnirEnabledProtectionsEventType} is corrupted.`);
        }
        const enabledProtections = new Set(input.enabled);
        const protection = (0, matrix_protection_suite_1.findProtection)("DraupnirNews");
        if (protection === undefined) {
            const message = `Cannot find the DraupnirNews protection`;
            return matrix_protection_suite_1.ActionException.Result(message, {
                exception: new TypeError(message),
                exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
            });
        }
        enabledProtections.add(protection.name);
        return (0, matrix_protection_suite_1.Ok)({
            enabled: [...enabledProtections],
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        });
    },
]);
//# sourceMappingURL=DefaultEnabledProtectionsMigration.js.map