"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SafeModeDraupnir = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const SafeModeCommandDispatcher_1 = require("./SafeModeCommandDispatcher");
const ManagementRoom_1 = require("./ManagementRoom");
const typescript_result_1 = require("@gnuxie/typescript-result");
const StatusCommand_1 = require("./commands/StatusCommand");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const RecoverCommand_1 = require("./commands/RecoverCommand");
const PersistentConfigEditor_1 = require("./PersistentConfigEditor");
class SafeModeDraupnir {
    constructor(cause, client, clientUserID, clientDisplayName, clientPlatform, managementRoom, clientRooms, safeModeToggle, config
    //private readonly roomStateManager: RoomStateManager,
    //private readonly policyRoomManager: PolicyRoomManager,
    //private readonly roomMembershipManager: RoomMembershipManager,
    ) {
        this.cause = cause;
        this.client = client;
        this.clientUserID = clientUserID;
        this.clientDisplayName = clientDisplayName;
        this.clientPlatform = clientPlatform;
        this.managementRoom = managementRoom;
        this.clientRooms = clientRooms;
        this.safeModeToggle = safeModeToggle;
        this.config = config;
        this.timelineEventListener = this.handleTimelineEvent.bind(this);
        this.commandDispatcher = (0, SafeModeCommandDispatcher_1.makeSafeModeCommandDispatcher)(this);
        this.commandDispatcherTimelineListener = (0, ManagementRoom_1.makeCommandDispatcherTimelineListener)(this.managementRoom, this.client, this.commandDispatcher);
        this.JSInterfaceDispatcher = (0, SafeModeCommandDispatcher_1.makeSafeModeJSDispatcher)(this);
        this.reactionHandler = new mps_interface_adaptor_1.MatrixReactionHandler(managementRoom.toRoomIDOrAlias(), this.clientUserID, this.clientPlatform);
        this.reactionHandler.on(mps_interface_adaptor_1.ARGUMENT_PROMPT_LISTENER, (0, mps_interface_adaptor_1.makeListenerForArgumentPrompt)(this.commandRoomID, this.commandDispatcher, this.reactionHandler));
        this.reactionHandler.on(mps_interface_adaptor_1.DEFAUILT_ARGUMENT_PROMPT_LISTENER, (0, mps_interface_adaptor_1.makeListenerForPromptDefault)(this.commandRoomID, this.commandDispatcher, this.reactionHandler));
        this.reactionHandler.on(mps_interface_adaptor_1.COMMAND_CONFIRMATION_LISTENER, (0, mps_interface_adaptor_1.makeConfirmationPromptListener)(this.commandRoomID, this.commandDispatcher, this.reactionHandler));
    }
    handleTimelineEvent(roomID, event) {
        this.commandDispatcherTimelineListener(roomID, event);
        void (0, matrix_protection_suite_1.Task)((async () => {
            await this.reactionHandler.handleEvent(roomID, event);
        })());
    }
    handleEventReport(_report) {
        throw new Error("Method not implemented.");
    }
    get commandRoomID() {
        return this.managementRoom.toRoomIDOrAlias();
    }
    /**
     * Start responding to events.
     * This will not start the appservice from listening and responding
     * to events. Nor will it start any syncing client.
     */
    start() {
        this.clientRooms.on("timeline", this.timelineEventListener);
    }
    stop() {
        this.clientRooms.off("timeline", this.timelineEventListener);
    }
    startupComplete() {
        void (0, matrix_protection_suite_1.Task)((async () => {
            const editor = new PersistentConfigEditor_1.StandardPersistentConfigEditor(this.client);
            const configStatus = await editor.supplementStatusWithSafeModeCause(this.cause);
            if ((0, typescript_result_1.isError)(configStatus)) {
                return configStatus.elaborate("Failed to fetch draupnir's persistent configuration");
            }
            return await (0, RecoverCommand_1.sendAndAnnotateWithRecoveryOptions)(this, (0, mps_interface_adaptor_1.wrapInRoot)((0, StatusCommand_1.renderSafeModeStatusInfo)((0, StatusCommand_1.safeModeStatusInfo)(this.cause, configStatus.ok))), {});
        })());
    }
    async sendTextCommand(sender, command) {
        return await this.JSInterfaceDispatcher.invokeCommandFromBody({ commandSender: sender }, command);
    }
}
exports.SafeModeDraupnir = SafeModeDraupnir;
//# sourceMappingURL=DraupnirSafeMode.js.map