"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirRestartError = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
class DraupnirRestartError extends typescript_result_1.ResultError {
    constructor(message, safeModeDraupnir) {
        super(message);
        this.safeModeDraupnir = safeModeDraupnir;
    }
    static Result(message, options) {
        return (0, typescript_result_1.Err)(new DraupnirRestartError(message, options.safeModeDraupnir));
    }
}
exports.DraupnirRestartError = DraupnirRestartError;
//# sourceMappingURL=SafeModeToggle.js.map