import { __awaiter } from 'tslib';
import { app } from 'electron';
import { writeFile, readFile, mkdir, stat, unlink, readdir, statSync } from 'fs';
import { join, resolve, dirname } from 'path';
import { promisify } from 'util';

const sentryCachePath = join(app ? app.getPath('userData') : '', 'sentry');
const writeFileAsync = promisify(writeFile);
const readFileAsync = promisify(readFile);
const mkdirAsync = promisify(mkdir);
const statAsync = promisify(stat);
const unlinkAsync = promisify(unlink);
const readDirAsync = promisify(readdir);
// mkdir with recursive was only added in Node 10+
/**
 * Recursively creates the given path.
 *
 * @param path A relative or absolute path to create.
 * @returns A Promise that resolves when the path has been created.
 */
function mkdirp(path) {
    return __awaiter(this, void 0, void 0, function* () {
        // eslint-disable-next-line no-bitwise
        const realPath = resolve(path);
        try {
            yield mkdirAsync(realPath, 0o777);
        }
        catch (err) {
            const error = err;
            if (error && error.code === 'ENOENT') {
                yield mkdirp(dirname(realPath));
                yield mkdirAsync(realPath, 0o777);
            }
            try {
                if (!statSync(realPath).isDirectory()) {
                    throw err;
                }
            }
            catch (_) {
                throw err;
            }
        }
    });
}

export { mkdirAsync, mkdirp, readDirAsync, readFileAsync, sentryCachePath, statAsync, unlinkAsync, writeFileAsync };
//# sourceMappingURL=fs.js.map
