(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.jssPluginExtend = {}));
}(this, (function (exports) { 'use strict';

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function warning(condition, message) {
    {
      if (condition) {
        return;
      }

      var text = "Warning: " + message;

      if (typeof console !== 'undefined') {
        console.warn(text);
      }

      try {
        throw Error(text);
      } catch (x) {}
    }
  }

  var isObject = function isObject(obj) {
    return obj && typeof obj === 'object' && !Array.isArray(obj);
  };

  var valueNs = "extendCurrValue" + Date.now();

  function mergeExtend(style, rule, sheet, newStyle) {
    var extendType = typeof style.extend; // Extend using a rule name.

    if (extendType === 'string') {
      if (!sheet) return;
      var refRule = sheet.getRule(style.extend);
      if (!refRule) return;

      if (refRule === rule) {
         warning(false, "[JSS] A rule tries to extend itself \n" + rule.toString()) ;
        return;
      }

      var parent = refRule.options.parent;

      if (parent) {
        var originalStyle = parent.rules.raw[style.extend];
        extend(originalStyle, rule, sheet, newStyle);
      }

      return;
    } // Extend using an array.


    if (Array.isArray(style.extend)) {
      for (var index = 0; index < style.extend.length; index++) {
        var singleExtend = style.extend[index];
        var singleStyle = typeof singleExtend === 'string' ? _extends({}, style, {
          extend: singleExtend
        }) : style.extend[index];
        extend(singleStyle, rule, sheet, newStyle);
      }

      return;
    } // Extend is a style object.


    for (var prop in style.extend) {
      if (prop === 'extend') {
        extend(style.extend.extend, rule, sheet, newStyle);
        continue;
      }

      if (isObject(style.extend[prop])) {
        if (!(prop in newStyle)) newStyle[prop] = {};
        extend(style.extend[prop], rule, sheet, newStyle[prop]);
        continue;
      }

      newStyle[prop] = style.extend[prop];
    }
  }

  function mergeRest(style, rule, sheet, newStyle) {
    // Copy base style.
    for (var prop in style) {
      if (prop === 'extend') continue;

      if (isObject(newStyle[prop]) && isObject(style[prop])) {
        extend(style[prop], rule, sheet, newStyle[prop]);
        continue;
      }

      if (isObject(style[prop])) {
        newStyle[prop] = extend(style[prop], rule, sheet);
        continue;
      }

      newStyle[prop] = style[prop];
    }
  }
  /**
   * Recursively extend styles.
   */


  function extend(style, rule, sheet, newStyle) {
    if (newStyle === void 0) {
      newStyle = {};
    }

    mergeExtend(style, rule, sheet, newStyle);
    mergeRest(style, rule, sheet, newStyle);
    return newStyle;
  }
  /**
   * Handle `extend` property.
   */


  function jssExtend() {
    function onProcessStyle(style, rule, sheet) {
      if ('extend' in style) return extend(style, rule, sheet);
      return style;
    }

    function onChangeValue(value, prop, rule) {
      if (prop !== 'extend') return value; // Value is empty, remove properties set previously.

      if (value == null || value === false) {
        for (var key in rule[valueNs]) {
          rule.prop(key, null);
        }

        rule[valueNs] = null;
        return null;
      }

      if (typeof value === 'object') {
        for (var _key in value) {
          rule.prop(_key, value[_key]);
        }

        rule[valueNs] = value;
      } // Make sure we don't set the value in the core.


      return null;
    }

    return {
      onProcessStyle: onProcessStyle,
      onChangeValue: onChangeValue
    };
  }

  exports.default = jssExtend;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=jss-plugin-extend.js.map
