"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.props = void 0;
const FieldProps_1 = require("./models/FieldProps");
exports.props = {
    editable: [
        FieldProps_1.FieldPropsEnum.type,
        FieldProps_1.FieldPropsEnum.value,
        FieldProps_1.FieldPropsEnum.initial,
        FieldProps_1.FieldPropsEnum.default,
        FieldProps_1.FieldPropsEnum.label,
        FieldProps_1.FieldPropsEnum.placeholder,
        FieldProps_1.FieldPropsEnum.related,
        FieldProps_1.FieldPropsEnum.options,
        FieldProps_1.FieldPropsEnum.extra,
        FieldProps_1.FieldPropsEnum.bindings,
        FieldProps_1.FieldPropsEnum.hooks,
        FieldProps_1.FieldPropsEnum.handlers,
        FieldProps_1.FieldPropsEnum.deleted,
        FieldProps_1.FieldPropsEnum.disabled,
        FieldProps_1.FieldPropsEnum.autoFocus,
        FieldProps_1.FieldPropsEnum.inputMode,
        FieldProps_1.FieldPropsEnum.ref,
    ],
    handlers: [
        FieldProps_1.FieldPropsEnum.onChange,
        FieldProps_1.FieldPropsEnum.onToggle,
        FieldProps_1.FieldPropsEnum.onFocus,
        FieldProps_1.FieldPropsEnum.onBlur,
        FieldProps_1.FieldPropsEnum.onDrop,
        FieldProps_1.FieldPropsEnum.onSubmit,
        FieldProps_1.FieldPropsEnum.onReset,
        FieldProps_1.FieldPropsEnum.onClear,
        FieldProps_1.FieldPropsEnum.onAdd,
        FieldProps_1.FieldPropsEnum.onDel,
    ],
    computed: [
        FieldProps_1.FieldPropsEnum.error,
        FieldProps_1.FieldPropsEnum.hasError,
        FieldProps_1.FieldPropsEnum.isValid,
        FieldProps_1.FieldPropsEnum.isDirty,
        FieldProps_1.FieldPropsEnum.isPristine,
        FieldProps_1.FieldPropsEnum.isDefault,
        FieldProps_1.FieldPropsEnum.isEmpty,
        FieldProps_1.FieldPropsEnum.focused,
        FieldProps_1.FieldPropsEnum.touched,
        FieldProps_1.FieldPropsEnum.changed,
        FieldProps_1.FieldPropsEnum.validating,
        FieldProps_1.FieldPropsEnum.submitting,
        FieldProps_1.FieldPropsEnum.resetting,
        FieldProps_1.FieldPropsEnum.clearing,
        FieldProps_1.FieldPropsEnum.blurred,
        FieldProps_1.FieldPropsEnum.deleted,
        FieldProps_1.FieldPropsEnum.disabled,
    ],
    separated: [
        FieldProps_1.SeparatedPropsMode.computed,
        FieldProps_1.SeparatedPropsMode.values,
        FieldProps_1.SeparatedPropsMode.labels,
        FieldProps_1.SeparatedPropsMode.placeholders,
        FieldProps_1.SeparatedPropsMode.defaults,
        FieldProps_1.SeparatedPropsMode.initials,
        FieldProps_1.SeparatedPropsMode.disabled,
        FieldProps_1.SeparatedPropsMode.deleted,
        FieldProps_1.SeparatedPropsMode.types,
        FieldProps_1.SeparatedPropsMode.related,
        FieldProps_1.SeparatedPropsMode.rules,
        FieldProps_1.SeparatedPropsMode.options,
        FieldProps_1.SeparatedPropsMode.bindings,
        FieldProps_1.SeparatedPropsMode.extra,
        FieldProps_1.SeparatedPropsMode.hooks,
        FieldProps_1.SeparatedPropsMode.handlers,
        FieldProps_1.SeparatedPropsMode.validatedWith,
        FieldProps_1.SeparatedPropsMode.validators,
        FieldProps_1.SeparatedPropsMode.observers,
        FieldProps_1.SeparatedPropsMode.interceptors,
        FieldProps_1.SeparatedPropsMode.converters,
        FieldProps_1.SeparatedPropsMode.input,
        FieldProps_1.SeparatedPropsMode.output,
        FieldProps_1.SeparatedPropsMode.autoFocus,
        FieldProps_1.SeparatedPropsMode.inputMode,
        FieldProps_1.SeparatedPropsMode.refs,
        FieldProps_1.SeparatedPropsMode.classes,
    ],
    functions: [
        FieldProps_1.FieldPropsEnum.computed,
        FieldProps_1.FieldPropsEnum.observers,
        FieldProps_1.FieldPropsEnum.interceptors,
        FieldProps_1.FieldPropsEnum.converter,
        FieldProps_1.FieldPropsEnum.input,
        FieldProps_1.FieldPropsEnum.output,
    ],
    validation: [
        FieldProps_1.FieldPropsEnum.rules,
        FieldProps_1.FieldPropsEnum.validators,
        FieldProps_1.FieldPropsEnum.validatedWith,
    ],
    occurrences: {
        isDirty: FieldProps_1.FieldPropsOccurrence.some,
        isPristine: FieldProps_1.FieldPropsOccurrence.every,
        isDefault: FieldProps_1.FieldPropsOccurrence.every,
        isValid: FieldProps_1.FieldPropsOccurrence.every,
        isEmpty: FieldProps_1.FieldPropsOccurrence.every,
        hasError: FieldProps_1.FieldPropsOccurrence.some,
        focused: FieldProps_1.FieldPropsOccurrence.some,
        blurred: FieldProps_1.FieldPropsOccurrence.some,
        touched: FieldProps_1.FieldPropsOccurrence.some,
        deleted: FieldProps_1.FieldPropsOccurrence.every,
        disabled: FieldProps_1.FieldPropsOccurrence.every,
        clearing: FieldProps_1.FieldPropsOccurrence.every,
        resetting: FieldProps_1.FieldPropsOccurrence.every,
    },
};
//# sourceMappingURL=props.js.map